/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging.slf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.BridgeAware;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogBuilder;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LoggingEventBuilder;

public class SLF4JToLog4jEventBuilder
implements LoggingEventBuilder {
    private static final String FQCN = SLF4JToLog4jEventBuilder.class.getName();
    private final SLF4JToLog4jMarkerFactory markerFactory;
    private final LogBuilder logBuilder;
    private final List<Object> arguments = new ArrayList<Object>();
    private String message = null;
    private Map<String, String> keyValuePairs = null;

    SLF4JToLog4jEventBuilder(SLF4JToLog4jMarkerFactory markerFactory, LogBuilder logBuilder) {
        this.markerFactory = markerFactory;
        this.logBuilder = logBuilder;
        if (logBuilder instanceof BridgeAware) {
            BridgeAware bridge = (BridgeAware)logBuilder;
            bridge.setEntryPoint(FQCN);
        }
    }

    public LoggingEventBuilder setCause(Throwable cause) {
        this.logBuilder.withThrowable(cause);
        return this;
    }

    public LoggingEventBuilder addMarker(Marker marker) {
        this.logBuilder.withMarker(this.markerFactory.getLog4jMarker(marker));
        return this;
    }

    public LoggingEventBuilder addArgument(Object p) {
        this.arguments.add(p);
        return this;
    }

    public LoggingEventBuilder addArgument(Supplier<?> objectSupplier) {
        this.arguments.add(objectSupplier.get());
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Object value) {
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new HashMap<String, String>();
        }
        this.keyValuePairs.put(key, String.valueOf(value));
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Supplier<Object> valueSupplier) {
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new HashMap<String, String>();
        }
        this.keyValuePairs.put(key, String.valueOf(valueSupplier.get()));
        return this;
    }

    public LoggingEventBuilder setMessage(String message) {
        this.message = message;
        return this;
    }

    public LoggingEventBuilder setMessage(Supplier<String> messageSupplier) {
        this.message = messageSupplier.get();
        return this;
    }

    public void log() {
        if (this.keyValuePairs == null || this.keyValuePairs.isEmpty()) {
            this.logBuilder.log(this.message, this.arguments.toArray());
        } else {
            try (CloseableThreadContext.Instance ignored = CloseableThreadContext.putAll(this.keyValuePairs);){
                this.logBuilder.log(this.message, this.arguments.toArray());
            }
        }
    }

    public void log(String message) {
        this.setMessage(message);
        this.log();
    }

    public void log(String message, Object arg) {
        this.setMessage(message);
        this.addArgument(arg);
        this.log();
    }

    public void log(String message, Object arg0, Object arg1) {
        this.setMessage(message);
        this.addArgument(arg0);
        this.addArgument(arg1);
        this.log();
    }

    public void log(String message, Object ... args) {
        this.setMessage(message);
        for (Object arg : args) {
            this.addArgument(arg);
        }
        this.log();
    }

    public void log(Supplier<String> messageSupplier) {
        this.setMessage(messageSupplier);
        this.log();
    }
}

