/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging.slf4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jEventBuilder;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventBuilder;
import org.slf4j.spi.NOPLoggingEventBuilder;

class SLF4JToLog4jLogger
implements LocationAwareLogger {
    private static final String FQCN = SLF4JToLog4jLogger.class.getName();
    private final SLF4JToLog4jMarkerFactory markerFactory;
    private final ExtendedLogger logger;
    private final String name;
    private final org.slf4j.event.Level logLevel;

    SLF4JToLog4jLogger(SLF4JToLog4jMarkerFactory markerFactory, ExtendedLogger logger, String name, org.slf4j.event.Level logLevel) {
        this.markerFactory = markerFactory;
        this.logger = logger;
        this.name = name;
        this.logLevel = logLevel;
    }

    public String getName() {
        return this.name;
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.TRACE, null);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.TRACE, null);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.TRACE, null);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.TRACE, null);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, msg, null, t, Level.TRACE, null);
        }
    }

    public boolean isTraceEnabled() {
        return this.logLevel.toInt() <= org.slf4j.event.Level.TRACE.toInt();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.TRACE, marker);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.TRACE, marker);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.TRACE, marker);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, format, argArray, null, Level.TRACE, marker);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.emitLogMessage(FQCN, msg, null, t, Level.TRACE, marker);
        }
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.DEBUG, null);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.DEBUG, null);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.DEBUG, null);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.DEBUG, null);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, msg, null, t, Level.DEBUG, null);
        }
    }

    public boolean isDebugEnabled() {
        return this.logLevel.toInt() <= org.slf4j.event.Level.DEBUG.toInt();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.DEBUG, marker);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.DEBUG, marker);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.DEBUG, marker);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.DEBUG, marker);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.emitLogMessage(FQCN, msg, null, t, Level.DEBUG, marker);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.INFO, null);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.INFO, null);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.INFO, null);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.INFO, null);
        }
    }

    public void info(String format, Throwable t) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, format, null, t, Level.INFO, null);
        }
    }

    public boolean isInfoEnabled() {
        return this.logLevel.toInt() <= org.slf4j.event.Level.INFO.toInt();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.INFO, marker);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.INFO, marker);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.INFO, marker);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.INFO, marker);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.emitLogMessage(FQCN, msg, null, t, Level.INFO, marker);
        }
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.WARN, null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.WARN, null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.WARN, null);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.WARN, null);
        }
    }

    public void warn(String format, Throwable t) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, format, null, t, Level.WARN, null);
        }
    }

    public boolean isWarnEnabled() {
        return this.logLevel.toInt() <= org.slf4j.event.Level.WARN.toInt();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.WARN, marker);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.WARN, marker);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.WARN, marker);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.WARN, marker);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.emitLogMessage(FQCN, msg, null, t, Level.WARN, marker);
        }
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.ERROR, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.ERROR, null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.ERROR, null);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.ERROR, null);
        }
    }

    public void error(String format, Throwable t) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, format, null, t, Level.ERROR, null);
        }
    }

    public boolean isErrorEnabled() {
        return this.logLevel.toInt() <= org.slf4j.event.Level.ERROR.toInt();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, msg, null, null, Level.ERROR, marker);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg}, null, Level.ERROR, marker);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, format, new Object[]{arg1, arg2}, null, Level.ERROR, marker);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, format, arguments, null, Level.ERROR, marker);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.emitLogMessage(FQCN, msg, null, t, Level.ERROR, marker);
        }
    }

    public void log(Marker slf4jMarker, String fqcn, int slf4jLevel, String message, Object[] argArray, Throwable t) {
        Level log4jLevel = SLF4JToLog4jLogger.getLog4jLevel(slf4jLevel);
        if (slf4jLevel < this.logLevel.toInt()) {
            return;
        }
        this.emitLogMessage(fqcn, message, argArray, t, log4jLevel, slf4jMarker);
    }

    private void emitLogMessage(String fqcn, String message, Object[] argArray, Throwable t, Level log4jLevel, Marker slf4jMarker) {
        if (argArray == null) {
            this.logger.logMessage(fqcn, log4jLevel, this.toLog4jMarker(slf4jMarker), (Message)new SimpleMessage(message), t);
        } else {
            ParameterizedMessage msg = new ParameterizedMessage(message, argArray, t);
            Throwable realThrowable = t != null ? t : msg.getThrowable();
            this.logger.logMessage(fqcn, log4jLevel, this.toLog4jMarker(slf4jMarker), (Message)msg, realThrowable);
        }
    }

    private org.apache.logging.log4j.Marker toLog4jMarker(Marker slf4jMarker) {
        if (slf4jMarker != null) {
            return this.markerFactory.getLog4jMarker(slf4jMarker);
        }
        return null;
    }

    private static Level getLog4jLevel(int i) {
        return switch (i) {
            case 0 -> Level.TRACE;
            case 10 -> Level.DEBUG;
            case 20 -> Level.INFO;
            case 30 -> Level.WARN;
            default -> Level.ERROR;
        };
    }

    public LoggingEventBuilder makeLoggingEventBuilder(org.slf4j.event.Level slf4jLevel) {
        Level log4jLevel = SLF4JToLog4jLogger.getLog4jLevel(slf4jLevel.toInt());
        if (slf4jLevel.toInt() >= this.logLevel.toInt()) {
            return new SLF4JToLog4jEventBuilder(this.markerFactory, this.logger.atLevel(log4jLevel));
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atTrace() {
        if (this.isTraceEnabled()) {
            return new SLF4JToLog4jEventBuilder(this.markerFactory, this.logger.atTrace());
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atDebug() {
        if (this.isDebugEnabled()) {
            return new SLF4JToLog4jEventBuilder(this.markerFactory, this.logger.atDebug());
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atInfo() {
        if (this.isInfoEnabled()) {
            return new SLF4JToLog4jEventBuilder(this.markerFactory, this.logger.atInfo());
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atWarn() {
        if (this.isWarnEnabled()) {
            return new SLF4JToLog4jEventBuilder(this.markerFactory, this.logger.atWarn());
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public LoggingEventBuilder atError() {
        if (this.isErrorEnabled()) {
            return new SLF4JToLog4jEventBuilder(this.markerFactory, this.logger.atError());
        }
        return NOPLoggingEventBuilder.singleton();
    }

    public boolean isEnabledForLevel(org.slf4j.event.Level slf4jLevel) {
        return this.logLevel.toInt() <= slf4jLevel.toInt();
    }
}

