/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

class TypedId {
    private final String type;
    private final long id;
    private final boolean isNode;

    public TypedId(String typedId) {
        this(typedId.substring(0, 1), Long.parseLong(typedId.substring(1)));
    }

    public TypedId(String type, long id) {
        this.type = type;
        this.id = id;
        this.isNode = type.equals("n");
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public boolean isNode() {
        return this.isNode;
    }

    public boolean isRelationship() {
        return !this.isNode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypedId)) {
            return false;
        }
        TypedId other = (TypedId)o;
        return this.type.equals(other.type) && this.id == other.id;
    }

    public int hashCode() {
        int code = 7;
        code = 31 * code + new Long(this.id).hashCode();
        code = 31 * code + this.type.hashCode();
        return code;
    }

    public String toString() {
        return this.type + this.id;
    }
}

