/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;

public class Start
extends GraphDatabaseApp {
    @Override
    public String getDescription() {
        return "Executes a Cypher query. Usage: start <rest of query>\nExample: START me = node({self}) MATCH me-[:KNOWS]->you RETURN you.name\nwhere {self} will be replaced with the current location in the graph";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String query = parser.getLine();
        if (this.endsWithNewLine(query) || this.looksToBeComplete(query)) {
            ExecutionEngine engine = new ExecutionEngine(this.getServer().getDb());
            try {
                ExecutionResult result = engine.execute(query, this.getParameters(session));
                out.println((Serializable)((Object)result.toString()));
            }
            catch (SyntaxException e) {
                throw ShellException.wrapCause(e);
            }
            return null;
        }
        return "c";
    }

    private Map<String, Object> getParameters(Session session) throws ShellException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            NodeOrRelationship self = this.getCurrent(session);
            params.put("self", self.isNode() ? self.asNode() : self.asRelationship());
        }
        catch (ShellException shellException) {
            // empty catch block
        }
        return params;
    }

    private boolean looksToBeComplete(String query) {
        return query.toLowerCase().contains("return");
    }

    private boolean endsWithNewLine(String query) {
        return query.length() > 0 && query.endsWith("\n");
    }
}

