/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.SimpleAppServer;
import org.neo4j.shell.impl.BashVariableInterpreter;
import org.neo4j.shell.kernel.ReadOnlyGraphDatabaseProxy;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;

public class GraphDatabaseShellServer
extends SimpleAppServer {
    private final GraphDatabaseService graphDb;
    private final BashVariableInterpreter bashInterpreter;
    private boolean graphDbCreatedHere;

    public GraphDatabaseShellServer(String path, boolean readOnly, String configFileOrNull) throws RemoteException {
        this(GraphDatabaseShellServer.instantiateGraphDb(path, readOnly, configFileOrNull), readOnly);
        this.graphDbCreatedHere = true;
    }

    public GraphDatabaseShellServer(GraphDatabaseService graphDb) throws RemoteException {
        this(graphDb, false);
    }

    public GraphDatabaseShellServer(GraphDatabaseService graphDb, boolean readOnly) throws RemoteException {
        this.graphDb = readOnly ? new ReadOnlyGraphDatabaseProxy(graphDb) : graphDb;
        this.bashInterpreter = new BashVariableInterpreter();
        this.bashInterpreter.addReplacer("W", new WorkingDirReplacer());
        this.setProperty("PS1", (Serializable)((Object)this.getShellPrompt()));
        this.setProperty("TITLE_KEYS", (Serializable)((Object)".*name.*,.*title.*"));
        this.setProperty("TITLE_MAX_LENGTH", (Serializable)((Object)"40"));
        this.graphDbCreatedHere = false;
    }

    private static GraphDatabaseService instantiateGraphDb(String path, boolean readOnly, String configFileOrNull) {
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(path).setConfig((GraphDatabaseSetting)GraphDatabaseSettings.read_only, Boolean.toString(readOnly));
        if (configFileOrNull != null) {
            builder.loadPropertiesFromFile(configFileOrNull);
        }
        return builder.newGraphDatabase();
    }

    protected String getShellPrompt() {
        String name = "neo4j-sh";
        if (this.graphDb instanceof ReadOnlyGraphDatabaseProxy) {
            name = name + "[readonly]";
        }
        name = name + " \\W$ ";
        return name;
    }

    @Override
    public String welcome() {
        return "Welcome to the Neo4j Shell! Enter 'help' for a list of commands";
    }

    @Override
    public Serializable interpretVariable(String key, Serializable value, Session session) throws ShellException {
        Object result = value;
        if (key.equals("PS1")) {
            result = this.bashInterpreter.interpret((String)((Object)value), this, session);
        }
        return result;
    }

    public GraphDatabaseService getDb() {
        return this.graphDb;
    }

    @Override
    public void shutdown() throws RemoteException {
        if (this.graphDbCreatedHere) {
            this.graphDb.shutdown();
        }
        super.shutdown();
    }

    public static class WorkingDirReplacer
    implements BashVariableInterpreter.Replacer {
        @Override
        public String getReplacement(ShellServer server, Session session) throws ShellException {
            try {
                return GraphDatabaseApp.getDisplayName((GraphDatabaseShellServer)server, session, GraphDatabaseApp.getCurrent((GraphDatabaseShellServer)server, session), false).toString();
            }
            catch (ShellException e) {
                return GraphDatabaseApp.getDisplayNameForNonExistent();
            }
        }
    }
}

