/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.neo4j.shell.App;
import org.neo4j.shell.AppShellServer;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TextUtil;

public class AppCommandParser {
    private final AppShellServer server;
    private final String line;
    private String appName;
    private App app;
    private Map<String, String> options = new HashMap<String, String>();
    private List<String> arguments = new ArrayList<String>();

    public AppCommandParser(AppShellServer server, String line) throws Exception {
        this.server = server;
        this.line = line;
        String trimmedLine = line != null ? this.prepareLine(line) : line;
        this.parse(trimmedLine);
    }

    private String prepareLine(String line) {
        return line.trim().replaceAll("\n", " ");
    }

    private void parse(String line) throws Exception {
        if (line == null || line.trim().length() == 0) {
            return;
        }
        this.parseApp(line);
        this.parseParameters(line);
    }

    public static String parseOutAppName(String line) {
        int index = AppCommandParser.findNextWhiteSpace(line, 0);
        return index == -1 ? line : line.substring(0, index);
    }

    private void parseApp(String line) throws Exception {
        int index = AppCommandParser.findNextWhiteSpace(line, 0);
        this.appName = index == -1 ? line : line.substring(0, index);
        this.appName = this.appName.toLowerCase();
        this.app = this.server.findApp(this.appName);
        if (this.app == null) {
            throw new ShellException("Unknown command '" + this.appName + "'");
        }
    }

    private void parseParameters(String line) throws ShellException {
        String rest = line.substring(this.appName.length()).trim();
        String[] parsed = AppCommandParser.tokenizeStringWithQuotes(rest, false);
        for (int i = 0; i < parsed.length; ++i) {
            String string = parsed[i];
            if (this.isMultiCharOption(string)) {
                String name = string.substring(2);
                i = this.fetchArguments(parsed, i, name);
                continue;
            }
            if (this.isSingleCharOption(string)) {
                String options = string.substring(1);
                for (int o = 0; o < options.length(); ++o) {
                    String name = String.valueOf(options.charAt(o));
                    i = this.fetchArguments(parsed, i, name);
                }
                continue;
            }
            if (string.length() <= 0) continue;
            this.arguments.add(string);
        }
    }

    private boolean isOption(String string) {
        return this.isSingleCharOption(string) || this.isMultiCharOption(string);
    }

    private boolean isMultiCharOption(String string) {
        return string.startsWith("--");
    }

    private boolean isSingleCharOption(String string) {
        return string.startsWith("-") && !this.isANegativeNumber(string);
    }

    private boolean isANegativeNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int fetchArguments(String[] parsed, int whereAreWe, String optionName) throws ShellException {
        OptionValueType type;
        String value = null;
        OptionDefinition definition = this.app.getOptionDefinition(optionName);
        OptionValueType optionValueType = type = definition == null ? OptionValueType.NONE : definition.getType();
        if (type == OptionValueType.MUST) {
            String message = "Value required for '" + optionName + "'";
            this.assertHasIndex(parsed, ++whereAreWe, message);
            value = parsed[whereAreWe];
            if (this.isOption(value)) {
                throw new ShellException(message);
            }
        } else if (type == OptionValueType.MAY && this.hasIndex(parsed, whereAreWe + 1) && !this.isOption(parsed[whereAreWe + 1])) {
            value = parsed[++whereAreWe];
        }
        this.options.put(optionName, value);
        return whereAreWe;
    }

    private boolean hasIndex(String[] array, int index) {
        return index >= 0 && index < array.length;
    }

    private void assertHasIndex(String[] array, int index, String message) throws ShellException {
        if (!this.hasIndex(array, index)) {
            throw new ShellException(message);
        }
    }

    private static int findNextWhiteSpace(String line, int fromIndex) {
        int index = line.indexOf(32, fromIndex);
        return index == -1 ? line.indexOf(9, fromIndex) : index;
    }

    public String getAppName() {
        return this.appName;
    }

    public App app() {
        return this.app;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public String option(String name, String defaultValue) {
        String result = this.options.get(name);
        return result != null ? result : defaultValue;
    }

    public Number optionAsNumber(String name, Number defaultValue) {
        String value = this.option(name, null);
        if (value != null) {
            if (value.indexOf(44) != -1 || value.indexOf(46) != -1) {
                return Double.valueOf(value);
            }
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public String argumentWithDefault(int index, String defaultValue) {
        return index < this.arguments.size() ? this.arguments.get(index) : defaultValue;
    }

    public String argument(int index, String errorMessageIfItDoesnExist) throws ShellException {
        if (index >= this.arguments.size()) {
            throw new ShellException(errorMessageIfItDoesnExist);
        }
        return this.arguments.get(index);
    }

    public String getLine() {
        return this.line;
    }

    public String getLineWithoutApp() {
        return this.line.substring(this.appName.length()).trim();
    }

    public static String[] tokenizeStringWithQuotes(String string) {
        return AppCommandParser.tokenizeStringWithQuotes(string, true);
    }

    public static String[] tokenizeStringWithQuotes(String string, boolean trim) {
        if (trim) {
            string = string.trim();
        }
        ArrayList<String> result = new ArrayList<String>();
        string = string.trim();
        boolean inside = string.startsWith("\"");
        StringTokenizer quoteTokenizer = new StringTokenizer(string, "\"");
        while (quoteTokenizer.hasMoreTokens()) {
            String token = quoteTokenizer.nextToken();
            if (trim) {
                token = token.trim();
            }
            if (token.length() != 0) {
                if (inside) {
                    result.add(token);
                } else {
                    for (String part : TextUtil.splitAndKeepEscapedSpaces(token, false)) {
                        result.add(part);
                    }
                }
            }
            inside = !inside;
        }
        return result.toArray(new String[result.size()]);
    }
}

