/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;

public enum UserSecurityGraphComponentVersion implements ComponentVersion
{
    COMMUNITY_SECURITY_40(1, SECURITY_USER_COMPONENT, "Neo4j 4.0"),
    COMMUNITY_SECURITY_41(2, SECURITY_USER_COMPONENT, "Neo4j 4.1"),
    COMMUNITY_SECURITY_43D4(3, SECURITY_USER_COMPONENT, "Neo4j 4.3.0-Drop04"),
    COMMUNITY_SECURITY_50(4, SECURITY_USER_COMPONENT, "Neo4j 5.0"),
    COMMUNITY_SECURITY_UNKNOWN_VERSION(-1, SECURITY_USER_COMPONENT, String.format("no '%s' graph found", SECURITY_USER_COMPONENT));

    public static final int FIRST_VALID_COMMUNITY_SECURITY_COMPONENT_VERSION;
    public static final int FIRST_RUNTIME_SUPPORTED_COMMUNITY_SECURITY_COMPONENT_VERSION;
    public static final int LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
    private final SystemGraphComponent.Name componentName;
    private final int version;
    private final String description;

    private UserSecurityGraphComponentVersion(int version, SystemGraphComponent.Name componentName, String description) {
        this.version = version;
        this.componentName = componentName;
        this.description = description;
    }

    public int getVersion() {
        return this.version;
    }

    public SystemGraphComponent.Name getComponentName() {
        return this.componentName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCurrent(Config config) {
        return this.version == LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
    }

    public boolean migrationSupported() {
        return this.version >= FIRST_VALID_COMMUNITY_SECURITY_COMPONENT_VERSION && this.version <= LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
    }

    public boolean runtimeSupported() {
        return this.version >= FIRST_RUNTIME_SUPPORTED_COMMUNITY_SECURITY_COMPONENT_VERSION && this.version <= LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
    }

    static {
        FIRST_VALID_COMMUNITY_SECURITY_COMPONENT_VERSION = COMMUNITY_SECURITY_40.getVersion();
        FIRST_RUNTIME_SUPPORTED_COMMUNITY_SECURITY_COMPONENT_VERSION = COMMUNITY_SECURITY_40.getVersion();
        LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION = COMMUNITY_SECURITY_50.getVersion();
    }
}

