/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.AuthenticationStrategy;

public class RateLimitedAuthenticationStrategy
implements AuthenticationStrategy {
    private final Clock clock;
    private final long lockDurationMs;
    private final int maxFailedAttempts;
    private final ConcurrentMap<String, AuthenticationMetadata> authenticationData = new ConcurrentHashMap<String, AuthenticationMetadata>();

    public RateLimitedAuthenticationStrategy(Clock clock, Config config) {
        this(clock, (Duration)config.get(GraphDatabaseSettings.auth_lock_time), (Integer)config.get(GraphDatabaseSettings.auth_max_failed_attempts));
    }

    RateLimitedAuthenticationStrategy(Clock clock, Duration lockDuration, int maxFailedAttempts) {
        this.clock = clock;
        this.lockDurationMs = lockDuration.toMillis();
        this.maxFailedAttempts = maxFailedAttempts;
    }

    @Override
    public AuthenticationResult authenticate(User user, byte[] password) {
        AuthenticationMetadata authMetadata = this.authMetadataFor(user.name());
        if (!authMetadata.authenticationPermitted()) {
            return AuthenticationResult.TOO_MANY_ATTEMPTS;
        }
        if (user.credential().value().matchesPassword(password)) {
            authMetadata.authSuccess();
            return AuthenticationResult.SUCCESS;
        }
        authMetadata.authFailed();
        return AuthenticationResult.FAILURE;
    }

    private AuthenticationMetadata authMetadataFor(String username) {
        AuthenticationMetadata preExisting;
        AuthenticationMetadata authMeta = (AuthenticationMetadata)this.authenticationData.get(username);
        if (authMeta == null && (preExisting = this.authenticationData.putIfAbsent(username, authMeta = new AuthenticationMetadata())) != null) {
            authMeta = preExisting;
        }
        return authMeta;
    }

    private class AuthenticationMetadata {
        private final AtomicInteger failedAuthAttempts = new AtomicInteger();
        private long lastFailedAttemptTime;

        private AuthenticationMetadata() {
        }

        boolean authenticationPermitted() {
            return RateLimitedAuthenticationStrategy.this.maxFailedAttempts <= 0 || this.failedAuthAttempts.get() < RateLimitedAuthenticationStrategy.this.maxFailedAttempts || RateLimitedAuthenticationStrategy.this.clock.millis() >= this.lastFailedAttemptTime + RateLimitedAuthenticationStrategy.this.lockDurationMs;
        }

        void authSuccess() {
            this.failedAuthAttempts.set(0);
        }

        void authFailed() {
            this.failedAuthAttempts.incrementAndGet();
            this.lastFailedAttemptTime = RateLimitedAuthenticationStrategy.this.clock.millis();
        }
    }
}

