/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.util.Map;
import java.util.Optional;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.server.security.SecureHasherConfiguration;

public abstract class SecureHasherConfigurations {
    static final String CURRENT_VERSION = "1";
    static final Map<String, SecureHasherConfiguration> configurations = Map.of("0", new SecureHasherConfiguration("SHA-256", 1), "1", new SecureHasherConfiguration("SHA-256", 1024));

    public static String getVersionForConfiguration(String algorithm, int iterations) {
        Optional<Map.Entry> entry = configurations.entrySet().stream().filter(configuration -> ((SecureHasherConfiguration)configuration.getValue()).algorithm.equals(algorithm) && ((SecureHasherConfiguration)configuration.getValue()).iterations == iterations).findFirst();
        if (entry.isPresent()) {
            return (String)entry.get().getKey();
        }
        throw new InvalidArgumentException(String.format("There exists no version with this combination of algorithm:'%s' and iterations:'%d'", algorithm, iterations));
    }
}

