/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.lang.util.ByteSource;
import org.neo4j.server.security.SecureHasherConfiguration;
import org.neo4j.server.security.SecureHasherConfigurations;

public class SecureHasher {
    private final String hashAlgorithm;
    private final int hashIterations;
    private static final int SALT_BYTES_SIZE = 32;
    private RandomNumberGenerator randomNumberGenerator;
    private HashedCredentialsMatcher hashedCredentialsMatcher;
    private Map<Integer, HashedCredentialsMatcher> hashedCredentialsMatchers;

    public SecureHasher() {
        this("1");
    }

    public SecureHasher(String version) {
        SecureHasherConfiguration configuration = SecureHasherConfigurations.configurations.get(version);
        this.hashAlgorithm = configuration.algorithm;
        this.hashIterations = configuration.iterations;
    }

    private RandomNumberGenerator getRandomNumberGenerator() {
        if (this.randomNumberGenerator == null) {
            this.randomNumberGenerator = new SecureRandomNumberGenerator();
        }
        return this.randomNumberGenerator;
    }

    public SimpleHash hash(byte[] source) {
        ByteSource salt = this.generateRandomSalt();
        return new SimpleHash(this.hashAlgorithm, (Object)source, (Object)salt, this.hashIterations);
    }

    public HashedCredentialsMatcher getHashedCredentialsMatcher() {
        if (this.hashedCredentialsMatcher == null) {
            this.hashedCredentialsMatcher = new HashedCredentialsMatcher(this.hashAlgorithm);
            this.hashedCredentialsMatcher.setHashIterations(this.hashIterations);
        }
        return this.hashedCredentialsMatcher;
    }

    public HashedCredentialsMatcher getHashedCredentialsMatcherWithIterations(int iterations) {
        HashedCredentialsMatcher matcher;
        if (this.hashedCredentialsMatchers == null) {
            this.hashedCredentialsMatchers = new HashMap<Integer, HashedCredentialsMatcher>();
        }
        if ((matcher = this.hashedCredentialsMatchers.get(iterations)) == null) {
            matcher = new HashedCredentialsMatcher(this.hashAlgorithm);
            matcher.setHashIterations(iterations);
            this.hashedCredentialsMatchers.put(iterations, matcher);
        }
        return matcher;
    }

    private ByteSource generateRandomSalt() {
        return this.getRandomNumberGenerator().nextBytes(32);
    }
}

