/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.security.FormatException;
import org.neo4j.string.UTF8;

public abstract class FileRepositorySerializer<S> {
    private final SecureRandom random = new SecureRandom();

    public static void writeToFile(FileSystemAbstraction fs, Path path, byte[] bytes) throws IOException {
        try (OutputStream o = fs.openAsOutputStream(path, false);){
            o.write(bytes);
        }
    }

    private static List<String> readFromFile(FileSystemAbstraction fs, Path path, MemoryTracker memoryTracker) throws IOException {
        return FileSystemUtils.readLines((FileSystemAbstraction)fs, (Path)path, (MemoryTracker)memoryTracker);
    }

    public void saveRecordsToFile(FileSystemAbstraction fileSystem, Path recordsFile, Collection<S> records) throws IOException {
        Path tempFile = this.getTempFile(fileSystem, recordsFile);
        try {
            FileRepositorySerializer.writeToFile(fileSystem, tempFile, this.serialize(records));
            fileSystem.renameFile(tempFile, recordsFile, new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING});
        }
        catch (Throwable e) {
            fileSystem.deleteFile(tempFile);
            throw e;
        }
    }

    private Path getTempFile(FileSystemAbstraction fileSystem, Path recordsFile) throws IOException {
        long n;
        Path directory = recordsFile.getParent();
        if (!fileSystem.fileExists(directory)) {
            fileSystem.mkdirs(directory);
        }
        n = (n = this.random.nextLong()) == Long.MIN_VALUE ? 0L : Math.abs(n);
        return directory.resolve(n + "_" + recordsFile.getFileName() + ".tmp");
    }

    public List<S> loadRecordsFromFile(FileSystemAbstraction fileSystem, Path recordsFile, MemoryTracker memoryTracker) throws IOException, FormatException {
        return this.deserializeRecords(FileRepositorySerializer.readFromFile(fileSystem, recordsFile, memoryTracker));
    }

    public byte[] serialize(Collection<S> records) {
        StringBuilder sb = new StringBuilder();
        for (S record : records) {
            sb.append(this.serialize(record)).append("\n");
        }
        return UTF8.encode((String)sb.toString());
    }

    public List<S> deserializeRecords(byte[] bytes) throws FormatException {
        return this.deserializeRecords(Arrays.asList(UTF8.decode((byte[])bytes).split("\n")));
    }

    private List<S> deserializeRecords(List<String> lines) throws FormatException {
        ArrayList<S> out = new ArrayList<S>();
        int lineNumber = 1;
        for (String line : lines) {
            if (!line.isBlank()) {
                out.add(this.deserializeRecord(line, lineNumber));
            }
            ++lineNumber;
        }
        return out;
    }

    protected abstract String serialize(S var1);

    protected abstract S deserializeRecord(String var1, int var2) throws FormatException;
}

