/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.kernel.database.DefaultDatabaseResolver;

public class CommunityDefaultDatabaseResolver
extends TransactionEventListenerAdapter<Object>
implements DefaultDatabaseResolver {
    private final AtomicReference<String> cachedDefaultDatabase = new AtomicReference();
    protected final Supplier<String> defaultDbSupplier;
    protected final SystemDatabaseProvider systemDbProvider;

    public CommunityDefaultDatabaseResolver(Config config, SystemDatabaseProvider systemDbProvider) {
        this(() -> (String)config.get(GraphDatabaseSettings.initial_default_database), systemDbProvider);
    }

    protected CommunityDefaultDatabaseResolver(Supplier<String> defaultDbSupplier, SystemDatabaseProvider systemDbProvider) {
        this.defaultDbSupplier = defaultDbSupplier;
        this.systemDbProvider = systemDbProvider;
    }

    public String defaultDatabase(String username) {
        String defaultDatabase = this.cachedDefaultDatabase.get();
        if (defaultDatabase == null) {
            defaultDatabase = ((Optional)this.systemDbProvider.query(CommunityDefaultDatabaseResolver::resolveDefaultDatabase)).orElseGet(this.defaultDbSupplier);
            this.cachedDefaultDatabase.set(defaultDatabase);
        }
        return defaultDatabase;
    }

    public void clearCache() {
        this.cachedDefaultDatabase.set(null);
    }

    public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
        this.clearCache();
    }

    private static Optional<String> resolveDefaultDatabase(Transaction tx) {
        return Optional.ofNullable(tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "default", (Object)true)).flatMap(defaultDatabaseNode -> Optional.ofNullable((String)defaultDatabaseNode.getProperty("name", null)));
    }
}

