/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.cypher.internal.security.FormatException;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponentVersion;
import org.neo4j.string.UTF8;

public abstract class KnownCommunitySecurityComponentVersion
extends KnownSystemComponentVersion {
    public static final Label USER_LABEL = Label.label((String)"User");
    private final SecureHasher secureHasher = new SecureHasher();

    KnownCommunitySecurityComponentVersion(ComponentVersion componentVersion, AbstractSecurityLog securityLog) {
        super(componentVersion, securityLog);
    }

    boolean componentNotInVersionNode(Transaction tx) {
        return this.getVersion(tx) == null;
    }

    public abstract void setupUsers(Transaction var1) throws Exception;

    public void addUser(Transaction tx, String username, Credential credentials, boolean passwordChangeRequired, boolean suspended) {
        this.securityLog.info(String.format("Creating new user '%s' (passwordChangeRequired=%b, suspended=%b)", username, passwordChangeRequired, suspended));
        Node node = tx.createNode(new Label[]{USER_LABEL});
        node.setProperty("name", (Object)username);
        node.setProperty("credentials", (Object)credentials.serialize());
        node.setProperty("passwordChangeRequired", (Object)passwordChangeRequired);
        node.setProperty("suspended", (Object)suspended);
        if (this.version >= UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_43D4.getVersion()) {
            node.setProperty("id", (Object)UUID.randomUUID().toString());
        }
    }

    public abstract void updateInitialUserPassword(Transaction var1) throws Exception;

    void updateInitialUserPassword(Transaction tx, User initialUser) throws FormatException {
        ResourceIterator nodes = tx.findNodes(USER_LABEL);
        List users = nodes.stream().collect(Collectors.toList());
        if (users.isEmpty()) {
            this.securityLog.warn(String.format("Unable to update missing initial user password from `auth.ini` file: %s", initialUser.name()));
        } else if (users.size() == 1) {
            SystemGraphCredential currentCredentials;
            Node user = (Node)users.get(0);
            if (user.getProperty("name").equals("neo4j") && (currentCredentials = SystemGraphCredential.deserialize((String)user.getProperty("credentials").toString(), (SecureHasher)this.secureHasher)).matchesPassword(UTF8.encode((String)"neo4j"))) {
                this.securityLog.info(String.format("Updating initial user password from `auth.ini` file: %s", initialUser.name()));
                user.setProperty("credentials", (Object)initialUser.credentials().serialize());
                user.setProperty("passwordChangeRequired", (Object)initialUser.passwordChangeRequired());
            }
        } else {
            this.securityLog.error(String.format("Multiple users matching initial user password from `auth.ini` file: %s", initialUser.name()));
        }
    }

    public void setUserIds(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(USER_LABEL);){
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                if (node.hasProperty("id")) continue;
                node.setProperty("id", (Object)UUID.randomUUID().toString());
            }
        }
    }

    public abstract void upgradeSecurityGraph(Transaction var1, int var2) throws Exception;
}

