/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import java.util.Optional;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.string.UTF8;

public abstract class SupportedCommunitySecurityComponentVersion
extends KnownCommunitySecurityComponentVersion {
    private final UserRepository userRepository;
    private final SecureHasher secureHasher;

    SupportedCommunitySecurityComponentVersion(ComponentVersion componentVersion, AbstractSecurityLog securityLog, UserRepository userRepository) {
        super(componentVersion, securityLog);
        this.userRepository = userRepository;
        this.secureHasher = new SecureHasher();
    }

    @Override
    public void setupUsers(Transaction tx) throws Exception {
        this.addDefaultUser(tx);
    }

    private void addDefaultUser(Transaction tx) throws Exception {
        Optional<User> initialUser = this.getInitialUser();
        if (initialUser.isPresent()) {
            User user = initialUser.get();
            this.securityLog.info(String.format("Setting up initial user from `auth.ini` file: %s", user.name()));
            this.addUser(tx, "neo4j", user.credentials(), user.passwordChangeRequired(), user.hasFlag("is_suspended"));
        } else {
            SystemGraphCredential credential = SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"neo4j"), (SecureHasher)this.secureHasher);
            this.securityLog.info(String.format("Setting up initial user from defaults: %s", "neo4j"));
            this.addUser(tx, "neo4j", (Credential)credential, true, false);
        }
    }

    @Override
    public void updateInitialUserPassword(Transaction tx) throws Exception {
        Optional<User> initialUser = this.getInitialUser();
        if (initialUser.isPresent()) {
            this.updateInitialUserPassword(tx, initialUser.get());
        } else {
            this.securityLog.debug("Not updating initial user password: No initial user found in `auth.ini`");
        }
    }

    private Optional<User> getInitialUser() throws Exception {
        this.userRepository.start();
        this.securityLog.debug("Opened `auth.ini` file to find the initial user");
        if (this.userRepository.numberOfUsers() == 0) {
            this.securityLog.debug("Not updating initial user password: No initial user found in `auth.ini`");
        }
        if (this.userRepository.numberOfUsers() == 1) {
            User initialUser = this.userRepository.getUserByName("neo4j");
            if (initialUser == null) {
                String errorMessage = "Invalid `auth.ini` file: the user in the file is not named neo4j";
                this.securityLog.error(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            this.securityLog.debug("Valid `auth.ini` file: found initial user");
            return Optional.of(initialUser);
        }
        if (this.userRepository.numberOfUsers() > 1) {
            String errorMessage = "Invalid `auth.ini` file: the file contains more than one user";
            this.securityLog.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        return Optional.empty();
    }
}

