/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.server.security.auth.AuthProcedures;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.server.security.systemgraph.SystemGraphRealmHelper;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.time.Clocks;

public class CommunitySecurityModule
extends SecurityModule {
    private final LogProvider logProvider;
    private final Config config;
    private final Dependencies globalDependencies;
    private BasicSystemGraphRealm authManager;
    private static final String USER_STORE_FILENAME = "auth";
    private static final String INITIAL_USER_STORE_FILENAME = "auth.ini";

    public CommunitySecurityModule(LogService logService, Config config, Dependencies globalDependencies) {
        this.logProvider = logService.getUserLogProvider();
        this.config = config;
        this.globalDependencies = globalDependencies;
    }

    public void setup() {
        Supplier<GraphDatabaseService> systemSupplier = () -> {
            DatabaseManager databaseManager = (DatabaseManager)this.globalDependencies.resolveDependency(DatabaseManager.class);
            return ((DatabaseContext)databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new RuntimeException("No database called `system` was found."))).databaseFacade();
        };
        this.authManager = new BasicSystemGraphRealm(new SystemGraphRealmHelper(systemSupplier, new SecureHasher()), CommunitySecurityModule.createAuthenticationStrategy(this.config));
        this.registerProcedure((GlobalProcedures)this.globalDependencies.resolveDependency(GlobalProcedures.class), this.logProvider.getLog(((Object)((Object)this)).getClass()), AuthProcedures.class, null);
    }

    public AuthManager authManager() {
        return this.authManager;
    }

    public AuthManager inClusterAuthManager() {
        return null;
    }

    public static FileUserRepository getUserRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileUserRepository(fileSystem, CommunitySecurityModule.getUserRepositoryFile(config), logProvider);
    }

    private static FileUserRepository getInitialUserRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileUserRepository(fileSystem, CommunitySecurityModule.getInitialUserRepositoryFile(config), logProvider);
    }

    public static Path getUserRepositoryFile(Config config) {
        Path authStore = (Path)config.get(GraphDatabaseInternalSettings.auth_store);
        if (Files.isRegularFile(authStore, new LinkOption[0])) {
            return authStore;
        }
        return CommunitySecurityModule.getUserRepositoryFile(config, USER_STORE_FILENAME);
    }

    public static Path getInitialUserRepositoryFile(Config config) {
        return CommunitySecurityModule.getUserRepositoryFile(config, INITIAL_USER_STORE_FILENAME);
    }

    private static Path getUserRepositoryFile(Config config, String fileName) {
        Path authStoreDir = (Path)config.get(DatabaseManagementSystemSettings.auth_store_directory);
        return authStoreDir.resolve(fileName);
    }

    public static UserSecurityGraphComponent createSecurityComponent(Log log, Config config, FileSystemAbstraction fileSystem, LogProvider logProvider) {
        FileUserRepository migrationUserRepository = CommunitySecurityModule.getUserRepository(config, logProvider, fileSystem);
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository(config, logProvider, fileSystem);
        return new UserSecurityGraphComponent(log, migrationUserRepository, initialUserRepository, config);
    }

    public static AuthenticationStrategy createAuthenticationStrategy(Config config) {
        return new RateLimitedAuthenticationStrategy(Clocks.systemClock(), config);
    }
}

