/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import java.util.Optional;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;

public class CommunityVersion_0_35
extends KnownCommunitySecurityComponentVersion {
    private final UserRepository userRepository;

    public CommunityVersion_0_35(Log log, UserRepository userRepository) {
        super(0, "Neo4j 3.5", log);
        this.userRepository = userRepository;
    }

    @Override
    public boolean detected(Transaction tx) {
        if (CommunityVersion_0_35.nodesWithLabelExist(tx, USER_LABEL) || this.getVersion(tx) != -1) {
            return false;
        }
        try {
            this.userRepository.start();
            return this.userRepository.numberOfUsers() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean migrationSupported() {
        return true;
    }

    @Override
    public void setupUsers(Transaction tx) {
        throw this.unsupported();
    }

    @Override
    public Optional<Exception> updateInitialUserPassword(Transaction tx) {
        return Optional.of(this.unsupported());
    }

    @Override
    public void upgradeSecurityGraph(Transaction tx, KnownCommunitySecurityComponentVersion latest) throws Exception {
        assert (latest.version == 2);
        this.userRepository.start();
        ListSnapshot<User> users = this.userRepository.getSnapshot();
        if (!users.values().isEmpty()) {
            for (User user : users.values()) {
                this.addUser(tx, user.name(), user.credentials(), user.passwordChangeRequired(), user.hasFlag("is_suspended"));
            }
            String userString = users.values().size() == 1 ? "user" : "users";
            this.log.info("Completed migration of %s %s into system graph.", new Object[]{Integer.toString(users.values().size()), userString});
        } else {
            this.log.info("No users migrated from auth file into system graph.");
        }
        this.setVersionProperty(tx, latest.version);
    }
}

