/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.AbstractUserRepository;
import org.neo4j.server.security.auth.FileRepository;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.UserSerialization;
import org.neo4j.server.security.auth.exception.FormatException;

public class FileUserRepository
extends AbstractUserRepository
implements FileRepository {
    private final File authFile;
    private final FileSystemAbstraction fileSystem;
    private final Log log;
    private final UserSerialization serialization = new UserSerialization();

    public FileUserRepository(FileSystemAbstraction fileSystem, File file, LogProvider logProvider) {
        this.fileSystem = fileSystem;
        this.authFile = file;
        this.log = logProvider.getLog(this.getClass());
    }

    public void start() throws Throwable {
        this.clear();
        FileRepository.assertNotMigrated(this.authFile, this.fileSystem, this.log);
        ListSnapshot<User> onDiskUsers = this.readPersistedUsers();
        if (onDiskUsers != null) {
            this.setUsers(onDiskUsers);
        }
    }

    @Override
    protected ListSnapshot<User> readPersistedUsers() throws IOException {
        if (this.fileSystem.fileExists(this.authFile)) {
            List readUsers;
            long readTime;
            try {
                readTime = this.fileSystem.lastModifiedTime(this.authFile);
                readUsers = this.serialization.loadRecordsFromFile(this.fileSystem, this.authFile);
            }
            catch (FormatException e) {
                this.log.error("Failed to read authentication file \"%s\" (%s)", new Object[]{this.authFile.getAbsolutePath(), e.getMessage()});
                throw new IllegalStateException("Failed to read authentication file: " + this.authFile);
            }
            return new ListSnapshot<User>(readTime, readUsers, true);
        }
        return null;
    }

    @Override
    protected void persistUsers() throws IOException {
        this.serialization.saveRecordsToFile(this.fileSystem, this.authFile, this.users);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSnapshot<User> getPersistedSnapshot() throws IOException {
        if (this.lastLoaded.get() < this.fileSystem.lastModifiedTime(this.authFile)) {
            return this.readPersistedUsers();
        }
        FileUserRepository fileUserRepository = this;
        synchronized (fileUserRepository) {
            return new ListSnapshot<User>(this.lastLoaded.get(), new ArrayList(this.users), false);
        }
    }

    @Override
    public void purge() throws IOException {
        super.purge();
        if (!this.fileSystem.deleteFile(this.authFile)) {
            throw new IOException("Failed to delete file '" + this.authFile.getAbsolutePath() + "'");
        }
    }

    @Override
    public void markAsMigrated() throws IOException {
        super.markAsMigrated();
        File destinationFile = FileRepository.getMigratedFile(this.authFile);
        this.fileSystem.renameFile(this.authFile, destinationFile, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES});
    }
}

