/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.server.security.auth.ListSnapshot;

public class SetInitialPasswordCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withMandatoryPositionalArgument(0, "password");
    private final Path homeDir;
    private final Path configDir;
    private OutsideWorld outsideWorld;

    SetInitialPasswordCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public static Arguments arguments() {
        return arguments;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        try {
            this.setPassword(arguments.parse(args).get(0));
        }
        catch (CommandFailed | IncorrectUsage e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandFailed(throwable.getMessage(), (Throwable)new RuntimeException(throwable));
        }
    }

    private void setPassword(String password) throws Throwable {
        Config config = this.loadNeo4jConfig();
        FileSystemAbstraction fileSystem = this.outsideWorld.fileSystem();
        if (this.realUsersExist(config)) {
            File authFile = CommunitySecurityModule.getUserRepositoryFile(config);
            throw new CommandFailed(this.realUsersExistErrorMsg(fileSystem, authFile));
        }
        File file = CommunitySecurityModule.getInitialUserRepositoryFile(config);
        if (fileSystem.fileExists(file)) {
            fileSystem.deleteFile(file);
        }
        FileUserRepository userRepository = new FileUserRepository(fileSystem, file, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        userRepository.create(new User.Builder("neo4j", (Credential)LegacyCredential.forPassword(password)).withRequiredPasswordChange(false).build());
        userRepository.shutdown();
        this.outsideWorld.stdOutLine("Changed password for user 'neo4j'.");
    }

    private boolean realUsersExist(Config config) {
        boolean result = false;
        File authFile = CommunitySecurityModule.getUserRepositoryFile(config);
        if (this.outsideWorld.fileSystem().fileExists(authFile)) {
            result = true;
            FileUserRepository userRepository = new FileUserRepository(this.outsideWorld.fileSystem(), authFile, (LogProvider)NullLogProvider.getInstance());
            try (Lifespan life = new Lifespan(new Lifecycle[]{userRepository});){
                User user;
                ListSnapshot<User> users = userRepository.getPersistedSnapshot();
                if (users.values().size() == 1 && "neo4j".equals((user = users.values().get(0)).name()) && user.credentials().matchesPassword("neo4j")) {
                    result = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private String realUsersExistErrorMsg(FileSystemAbstraction fileSystem, File authFile) {
        File parentFile = authFile.getParentFile();
        File roles = new File(parentFile, "roles");
        String files = fileSystem.fileExists(roles) ? "`auth` and `roles` files" : "`auth` file";
        return "the provided initial password was not set because existing Neo4j users were detected at `" + authFile.getAbsolutePath() + "`. Please remove the existing " + files + " if you want to reset your database to only have a default user with the provided password.";
    }

    Config loadNeo4jConfig() {
        return Config.fromFile((File)this.configDir.resolve("neo4j.conf").toFile()).withHome(this.homeDir.toFile()).withConnectorsDisabled().build();
    }
}

