/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.LegacyCredential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.FileRepositorySerializer;
import org.neo4j.server.security.auth.exception.FormatException;
import org.neo4j.string.HexString;

public class UserSerialization
extends FileRepositorySerializer<User> {
    private static final String userSeparator = ":";
    private static final String credentialSeparator = ",";

    @Override
    protected String serialize(User user) {
        return String.join((CharSequence)userSeparator, user.name(), this.serialize((LegacyCredential)user.credentials()), String.join((CharSequence)credentialSeparator, user.getFlags()));
    }

    @Override
    protected User deserializeRecord(String line, int lineNumber) throws FormatException {
        String[] parts = line.split(userSeparator, -1);
        if (parts.length != 3) {
            throw new FormatException(String.format("wrong number of line fields, expected 3, got %d [line %d]", parts.length, lineNumber));
        }
        User.Builder b = new User.Builder().withName(parts[0]).withCredentials((Credential)this.deserializeCredentials(parts[1], lineNumber));
        for (String flag : parts[2].split(credentialSeparator, -1)) {
            String trimmed = flag.trim();
            if (trimmed.isEmpty()) continue;
            b = b.withFlag(trimmed);
        }
        return b.build();
    }

    @Override
    private String serialize(LegacyCredential cred) {
        String encodedSalt = HexString.encodeHexString((byte[])cred.salt());
        String encodedPassword = HexString.encodeHexString((byte[])cred.passwordHash());
        return String.join((CharSequence)credentialSeparator, "SHA-256", encodedPassword, encodedSalt);
    }

    private LegacyCredential deserializeCredentials(String part, int lineNumber) throws FormatException {
        String[] split = part.split(credentialSeparator, -1);
        if (split.length != 3) {
            throw new FormatException(String.format("wrong number of credential fields [line %d]", lineNumber));
        }
        if (!split[0].equals("SHA-256")) {
            throw new FormatException(String.format("unknown digest \"%s\" [line %d]", split[0], lineNumber));
        }
        byte[] decodedPassword = HexString.decodeHexString((String)split[1]);
        byte[] decodedSalt = HexString.decodeHexString((String)split[2]);
        return new LegacyCredential(decodedSalt, decodedPassword);
    }
}

