/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;

public class SetDefaultAdminCommand
implements AdminCommand {
    public static final String ADMIN_INI = "admin.ini";
    public static final String COMMAND_NAME = "set-default-admin";
    public static final Arguments arguments = new Arguments().withMandatoryPositionalArgument(0, "username");
    private final Path homeDir;
    private final Path configDir;
    private OutsideWorld outsideWorld;

    SetDefaultAdminCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Args parsedArgs = this.validateArgs(args);
        try {
            this.setDefaultAdmin((String)parsedArgs.orphans().get(0));
        }
        catch (CommandFailed | IncorrectUsage e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandFailed(throwable.getMessage(), (Exception)new RuntimeException(throwable));
        }
    }

    private Args validateArgs(String[] args) throws IncorrectUsage {
        Args parsedArgs = Args.parse((String[])args);
        if (parsedArgs.orphans().size() < 1) {
            throw new IncorrectUsage("no username specified.");
        }
        if (parsedArgs.orphans().size() > 1) {
            throw new IncorrectUsage("too many arguments.");
        }
        return parsedArgs;
    }

    private void setDefaultAdmin(String username) throws Throwable {
        FileSystemAbstraction fileSystem = this.outsideWorld.fileSystem();
        Config config = this.loadNeo4jConfig();
        FileUserRepository users = CommunitySecurityModule.getUserRepository(config, (LogProvider)NullLogProvider.getInstance(), fileSystem);
        users.init();
        users.start();
        Set<String> userNames = users.getAllUsernames();
        users.stop();
        users.shutdown();
        if (userNames.isEmpty()) {
            FileUserRepository initialUsers = CommunitySecurityModule.getInitialUserRepository(config, (LogProvider)NullLogProvider.getInstance(), fileSystem);
            initialUsers.init();
            initialUsers.start();
            userNames = initialUsers.getAllUsernames();
            initialUsers.stop();
            initialUsers.shutdown();
        }
        if (!userNames.contains(username)) {
            throw new CommandFailed(String.format("no such user: '%s'", username));
        }
        File adminIniFile = new File(CommunitySecurityModule.getUserRepositoryFile(config).getParentFile(), ADMIN_INI);
        if (fileSystem.fileExists(adminIniFile)) {
            fileSystem.deleteFile(adminIniFile);
        }
        FileUserRepository admins = new FileUserRepository(fileSystem, adminIniFile, (LogProvider)NullLogProvider.getInstance());
        admins.init();
        admins.start();
        admins.create(new User.Builder(username, Credential.INACCESSIBLE).build());
        admins.stop();
        admins.shutdown();
        this.outsideWorld.stdOutLine("default admin user set to '" + username + "'");
    }

    Config loadNeo4jConfig() {
        return ConfigLoader.loadConfigWithConnectorsDisabled(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile()), (Pair[])new Pair[0]);
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super(SetDefaultAdminCommand.COMMAND_NAME, new String[0]);
        }

        public Arguments allArguments() {
            return arguments;
        }

        public String description() {
            return "Sets the user to become admin if users but no roles are present, for example when upgrading to neo4j 3.1 enterprise.";
        }

        public String summary() {
            return "Sets the default admin user when no roles are present.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new SetDefaultAdminCommand(homeDir, configDir, outsideWorld);
        }
    }
}

