/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserManager;

public class AuthProcedures {
    @Context
    public SecurityContext securityContext;
    @Context
    public UserManager userManager;

    @Description(value="Create a new user.")
    @Procedure(name="dbms.security.createUser", mode=Mode.DBMS)
    public void createUser(@Name(value="username") String username, @Name(value="password") String password, @Name(value="requirePasswordChange", defaultValue="true") boolean requirePasswordChange) throws InvalidArgumentsException, IOException {
        this.userManager.newUser(username, password, requirePasswordChange);
    }

    @Description(value="Delete the specified user.")
    @Procedure(name="dbms.security.deleteUser", mode=Mode.DBMS)
    public void deleteUser(@Name(value="username") String username) throws InvalidArgumentsException, IOException {
        if (this.securityContext.subject().hasUsername(username)) {
            throw new InvalidArgumentsException("Deleting yourself (user '" + username + "') is not allowed.");
        }
        this.userManager.deleteUser(username);
    }

    @Deprecated
    @Description(value="Change the current user's password. Deprecated by dbms.security.changePassword.")
    @Procedure(name="dbms.changePassword", mode=Mode.DBMS, deprecatedBy="dbms.security.changePassword")
    public void changePasswordDeprecated(@Name(value="password") String password) throws InvalidArgumentsException, IOException {
        this.changePassword(password);
    }

    @Description(value="Change the current user's password.")
    @Procedure(name="dbms.security.changePassword", mode=Mode.DBMS)
    public void changePassword(@Name(value="password") String password) throws InvalidArgumentsException, IOException {
        if (this.securityContext.subject() == AuthSubject.ANONYMOUS) {
            throw new AuthorizationViolationException("Anonymous cannot change password");
        }
        this.userManager.setUserPassword(this.securityContext.subject().username(), password, false);
        this.securityContext.subject().setPasswordChangeNoLongerRequired();
    }

    @Description(value="Show the current user.")
    @Procedure(name="dbms.security.showCurrentUser", mode=Mode.DBMS)
    public Stream<UserResult> showCurrentUser() throws InvalidArgumentsException, IOException {
        return Stream.of(this.userResultForName(this.securityContext.subject().username()));
    }

    @Description(value="List all local users.")
    @Procedure(name="dbms.security.listUsers", mode=Mode.DBMS)
    public Stream<UserResult> listUsers() throws InvalidArgumentsException, IOException {
        Set<String> usernames = this.userManager.getAllUsernames();
        if (usernames.isEmpty()) {
            return this.showCurrentUser();
        }
        return usernames.stream().map(this::userResultForName);
    }

    private UserResult userResultForName(String username) {
        User user = this.userManager.silentlyGetUser(username);
        List<String> flags = user == null ? Collections.emptyList() : user.getFlags();
        return new UserResult(username, flags);
    }

    public static class UserResult {
        public final String username;
        public final List<String> flags;

        UserResult(String username, Iterable<String> flags) {
            this.username = username;
            this.flags = new ArrayList<String>();
            for (String f : flags) {
                this.flags.add(f);
            }
        }
    }
}

