/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.User;

public class BasicAuthSubject
implements AuthSubject {
    private final BasicAuthManager authManager;
    private User user;
    private AuthenticationResult authenticationResult;
    private AccessMode.Static accessMode;

    public static BasicAuthSubject castOrFail(AuthSubject authSubject) {
        if (!(authSubject instanceof BasicAuthSubject)) {
            throw new IllegalArgumentException("Incorrect AuthSubject type " + authSubject.getClass().getTypeName());
        }
        return (BasicAuthSubject)authSubject;
    }

    public BasicAuthSubject(BasicAuthManager authManager, User user, AuthenticationResult authenticationResult) {
        this.authManager = authManager;
        this.user = user;
        this.authenticationResult = authenticationResult;
        switch (authenticationResult) {
            case SUCCESS: {
                this.accessMode = AccessMode.Static.FULL;
                break;
            }
            case PASSWORD_CHANGE_REQUIRED: {
                this.accessMode = AccessMode.Static.CREDENTIALS_EXPIRED;
                break;
            }
            default: {
                this.accessMode = AccessMode.Static.NONE;
            }
        }
    }

    public void logout() {
        this.user = null;
        this.authenticationResult = AuthenticationResult.FAILURE;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public void setPassword(String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        this.authManager.setPassword(this, this.user.name(), password, requirePasswordChange);
        if (this.authenticationResult == AuthenticationResult.PASSWORD_CHANGE_REQUIRED) {
            this.authenticationResult = AuthenticationResult.SUCCESS;
            this.accessMode = AccessMode.Static.FULL;
        }
    }

    public boolean allowsProcedureWith(String[] roleName) {
        return true;
    }

    public BasicAuthManager getAuthManager() {
        return this.authManager;
    }

    public boolean hasUsername(String username) {
        return this.username().equals(username);
    }

    public boolean allowsReads() {
        return this.accessMode.allowsReads();
    }

    public boolean allowsWrites() {
        return this.accessMode.allowsWrites();
    }

    public boolean allowsSchemaWrites() {
        return this.accessMode.allowsSchemaWrites();
    }

    public boolean overrideOriginalMode() {
        return false;
    }

    public AuthorizationViolationException onViolation(String msg) {
        return this.accessMode.onViolation(msg);
    }

    public String name() {
        return this.username();
    }

    public String username() {
        return this.user.name();
    }
}

