/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.File;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.PasswordPolicy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.time.Clocks;

public class BasicAuthManagerFactory
extends AuthManager.Factory {
    private static final String USER_STORE_FILENAME = "auth";

    public static FileUserRepository getUserRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        File authStoreDir = (File)config.get(DatabaseManagementSystemSettings.auth_store_directory);
        File userStoreFile = (File)config.get(GraphDatabaseSettings.auth_store);
        if (userStoreFile == null) {
            userStoreFile = new File(authStoreDir, USER_STORE_FILENAME);
        }
        return new FileUserRepository(fileSystem, userStoreFile, logProvider);
    }

    public BasicAuthManagerFactory() {
        super("basic-auth-manager", new String[0]);
    }

    public AuthManager newInstance(Config config, LogProvider logProvider, Log ignored, FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        if (!((Boolean)config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            throw new IllegalStateException("Attempted to build BasicAuthManager even though configuration setting auth_enabled=false");
        }
        FileUserRepository userRepository = BasicAuthManagerFactory.getUserRepository(config, logProvider, fileSystem);
        BasicPasswordPolicy passwordPolicy = new BasicPasswordPolicy();
        return new BasicAuthManager((UserRepository)userRepository, (PasswordPolicy)passwordPolicy, Clocks.systemClock());
    }

    public static interface Dependencies {
        public Config config();

        public LogService logService();
    }
}

