/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicAuthSubject;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.PasswordPolicy;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserManager;
import org.neo4j.server.security.auth.UserManagerSupplier;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;

public class BasicAuthManager
implements AuthManager,
UserManager,
UserManagerSupplier {
    protected final AuthenticationStrategy authStrategy;
    protected final UserRepository userRepository;
    protected final PasswordPolicy passwordPolicy;

    public BasicAuthManager(UserRepository userRepository, PasswordPolicy passwordPolicy, AuthenticationStrategy authStrategy) {
        this.userRepository = userRepository;
        this.passwordPolicy = passwordPolicy;
        this.authStrategy = authStrategy;
    }

    public BasicAuthManager(UserRepository userRepository, PasswordPolicy passwordPolicy, Clock clock) {
        this(userRepository, passwordPolicy, new RateLimitedAuthenticationStrategy(clock, 3));
    }

    public void init() throws Throwable {
        this.userRepository.init();
    }

    public void start() throws Throwable {
        this.userRepository.start();
        if (this.userRepository.numberOfUsers() == 0) {
            this.newUser("neo4j", "neo4j", true);
        }
    }

    public void stop() throws Throwable {
        this.userRepository.stop();
    }

    public void shutdown() throws Throwable {
        this.userRepository.shutdown();
    }

    public BasicAuthSubject login(Map<String, Object> authToken) throws InvalidAuthTokenException {
        String scheme = AuthToken.safeCast((String)"scheme", authToken);
        if (!scheme.equals("basic")) {
            throw new InvalidAuthTokenException("Unsupported authentication scheme '" + scheme + "'.");
        }
        String username = AuthToken.safeCast((String)"principal", authToken);
        String password = AuthToken.safeCast((String)"credentials", authToken);
        User user = this.userRepository.getUserByName(username);
        AuthenticationResult result = AuthenticationResult.FAILURE;
        if (user != null && (result = this.authStrategy.authenticate(user, password)) == AuthenticationResult.SUCCESS && user.passwordChangeRequired()) {
            result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
        }
        return new BasicAuthSubject(this, user, result);
    }

    @Override
    public User newUser(String username, String initialPassword, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        this.userRepository.assertValidUsername(username);
        this.passwordPolicy.validatePassword(initialPassword);
        User user = new User.Builder().withName(username).withCredentials(Credential.forPassword(initialPassword)).withRequiredPasswordChange(requirePasswordChange).build();
        this.userRepository.create(user);
        return user;
    }

    @Override
    public boolean deleteUser(String username) throws IOException, InvalidArgumentsException {
        User user = this.getUser(username);
        return user != null && this.userRepository.delete(user);
    }

    @Override
    public User getUser(String username) throws InvalidArgumentsException {
        User user = this.userRepository.getUserByName(username);
        if (user == null) {
            throw new InvalidArgumentsException("User '" + username + "' does not exist.");
        }
        return user;
    }

    public void setPassword(AuthSubject authSubject, String username, String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        BasicAuthSubject basicAuthSubject = BasicAuthSubject.castOrFail(authSubject);
        if (!basicAuthSubject.hasUsername(username)) {
            throw new AuthorizationViolationException("Invalid attempt to change the password for user " + username);
        }
        this.setUserPassword(username, password, requirePasswordChange);
    }

    @Override
    public void setUserPassword(String username, String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        User existingUser = this.getUser(username);
        this.passwordPolicy.validatePassword(password);
        if (existingUser.credentials().matchesPassword(password)) {
            throw new InvalidArgumentsException("Old password and new password cannot be the same.");
        }
        try {
            User updatedUser = existingUser.augment().withCredentials(Credential.forPassword(password)).withRequiredPasswordChange(false).build();
            this.userRepository.update(existingUser, updatedUser);
        }
        catch (ConcurrentModificationException e) {
            this.setUserPassword(username, password, requirePasswordChange);
        }
    }

    @Override
    public Set<String> getAllUsernames() {
        return this.userRepository.getAllUsernames();
    }

    @Override
    public UserManager getUserManager() {
        return this;
    }
}

