/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.server.security.auth.BasicAuthSubject;

public class AuthProcedures {
    @Context
    public AuthSubject authSubject;

    @Description(value="Create a new user.")
    @Procedure(name="dbms.security.createUser", mode=Mode.DBMS)
    public void createUser(@Name(value="username") String username, @Name(value="password") String password, @Name(value="requirePasswordChange", defaultValue="true") boolean requirePasswordChange) throws InvalidArgumentsException, IOException {
        BasicAuthSubject subject = BasicAuthSubject.castOrFail(this.authSubject);
        subject.getAuthManager().newUser(username, password, requirePasswordChange);
    }

    @Description(value="Delete the specified user.")
    @Procedure(name="dbms.security.deleteUser", mode=Mode.DBMS)
    public void deleteUser(@Name(value="username") String username) throws InvalidArgumentsException, IOException {
        BasicAuthSubject subject = BasicAuthSubject.castOrFail(this.authSubject);
        if (subject.hasUsername(username)) {
            throw new InvalidArgumentsException("Deleting yourself (user '" + username + "') is not allowed.");
        }
        subject.getAuthManager().deleteUser(username);
    }

    @Deprecated
    @Description(value="Change the current user's password. Deprecated by dbms.security.changePassword.")
    @Procedure(name="dbms.changePassword", mode=Mode.DBMS, deprecatedBy="dbms.security.changePassword")
    public void changePasswordDeprecated(@Name(value="password") String password) throws InvalidArgumentsException, IOException {
        this.authSubject.setPassword(password, false);
    }

    @Description(value="Change the current user's password.")
    @Procedure(name="dbms.security.changePassword", mode=Mode.DBMS)
    public void changePassword(@Name(value="password") String password) throws InvalidArgumentsException, IOException {
        this.authSubject.setPassword(password, false);
    }

    @Description(value="Show the current user.")
    @Procedure(name="dbms.security.showCurrentUser", mode=Mode.DBMS)
    public Stream<UserResult> showCurrentUser() throws InvalidArgumentsException, IOException {
        BasicAuthSubject subject = BasicAuthSubject.castOrFail(this.authSubject);
        return Stream.of(new UserResult(subject.name(), subject.getAuthManager().getUser(subject.name()).getFlags()));
    }

    @Description(value="List all local users.")
    @Procedure(name="dbms.security.listUsers", mode=Mode.DBMS)
    public Stream<UserResult> listUsers() throws InvalidArgumentsException, IOException {
        BasicAuthSubject subject = BasicAuthSubject.castOrFail(this.authSubject);
        Set<String> usernames = subject.getAuthManager().getAllUsernames();
        ArrayList<UserResult> results = new ArrayList<UserResult>();
        for (String username : usernames) {
            results.add(new UserResult(username, subject.getAuthManager().getUser(username).getFlags()));
        }
        return results.stream();
    }

    public static class UserResult {
        public final String username;
        public final List<String> flags;

        UserResult(String username, Iterable<String> flags) {
            this.username = username;
            this.flags = new ArrayList<String>();
            for (String f : flags) {
                this.flags.add(f);
            }
        }
    }
}

