/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicAuthManagerFactory;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.PasswordPolicy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.time.Clocks;

public class UsersCommand
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;
    private OutsideWorld outsideWorld;

    public UsersCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Args parsedArgs = Args.parse((String[])args);
        if (parsedArgs.orphans().size() < 1) {
            throw new IncorrectUsage("Missing arguments: expected at least one sub-command as argument: list, create, delete or set-password");
        }
        String command = parsedArgs.orphans().size() > 0 ? (String)parsedArgs.orphans().get(0) : null;
        String username = parsedArgs.orphans().size() > 1 ? (String)parsedArgs.orphans().get(1) : null;
        String password = parsedArgs.orphans().size() > 2 ? (String)parsedArgs.orphans().get(2) : null;
        boolean requiresPasswordChange = !this.hasFlagWithValue(parsedArgs, "requires-password-change", "false");
        try {
            switch (command.trim().toLowerCase()) {
                case "list": {
                    this.listUsers(username);
                    break;
                }
                case "set-password": {
                    if (username == null || password == null) {
                        throw new IncorrectUsage("Missing arguments: 'users set-password' expects username and password arguments");
                    }
                    this.setPassword(username, password, requiresPasswordChange);
                    break;
                }
                case "create": {
                    if (username == null || password == null) {
                        throw new IncorrectUsage("Missing arguments: 'users create' expects username and password arguments");
                    }
                    this.createUser(username, password, requiresPasswordChange);
                    break;
                }
                case "delete": {
                    if (username == null) {
                        throw new IncorrectUsage("Missing arguments: 'users delete' expects username argument");
                    }
                    this.deleteUser(username);
                    break;
                }
                default: {
                    throw new IncorrectUsage("Unknown users command: " + command);
                }
            }
        }
        catch (IncorrectUsage e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandFailed("Failed run 'users " + command + "' on '" + username + "': " + e.getMessage(), e);
        }
        catch (Throwable t) {
            throw new CommandFailed("Failed run 'users " + command + "' on '" + username + "': " + t.getMessage(), (Exception)new RuntimeException(t.getMessage()));
        }
    }

    private boolean hasFlagWithValue(Args parsedArgs, String key, String expectedValue) {
        Map argsMap = parsedArgs.asMap();
        return argsMap.containsKey(key) && ((String)argsMap.get(key)).trim().toLowerCase().equals(expectedValue);
    }

    private void listUsers(String contains) throws Throwable {
        this.getAuthManager();
        FileUserRepository userRepository = this.getUserRepository();
        for (String username : userRepository.getAllUsernames()) {
            if (contains != null && !username.toLowerCase().contains(contains.toLowerCase())) continue;
            this.outsideWorld.stdOutLine(username);
        }
    }

    private void createUser(String username, String password, boolean requiresPasswordChange) throws Throwable {
        BasicAuthManager authManager = this.getAuthManager();
        authManager.newUser(username, password, requiresPasswordChange);
        this.outsideWorld.stdOutLine("Created new user '" + username + "'");
    }

    private void deleteUser(String username) throws Throwable {
        BasicAuthManager authManager = this.getAuthManager();
        authManager.getUser(username);
        if (authManager.getAllUsernames().size() == 1) {
            throw new IllegalArgumentException("Deleting the only remaining user '" + username + "' is not allowed");
        }
        if (authManager.deleteUser(username)) {
            this.outsideWorld.stdOutLine("Deleted user '" + username + "'");
        } else {
            this.outsideWorld.stdErrLine("Failed to delete user '" + username + "'");
        }
    }

    private void setPassword(String username, String password, boolean requirePasswordChange) throws Throwable {
        BasicAuthManager authManager = this.getAuthManager();
        authManager.setUserPassword(username, password, requirePasswordChange);
        this.outsideWorld.stdOutLine("Changed password for user '" + username + "'");
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir) {
        ConfigLoader configLoader = new ConfigLoader(UsersCommand.settings());
        return configLoader.loadConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()), new Pair[0]);
    }

    private static List<Class<?>> settings() {
        ArrayList settings = new ArrayList();
        settings.add(GraphDatabaseSettings.class);
        settings.add(DatabaseManagementSystemSettings.class);
        return settings;
    }

    private FileUserRepository getUserRepository() throws Throwable {
        Config config = UsersCommand.loadNeo4jConfig(this.homeDir, this.configDir);
        FileUserRepository userRepository = BasicAuthManagerFactory.getUserRepository(config, (LogProvider)NullLogProvider.getInstance(), this.outsideWorld.fileSystem());
        userRepository.start();
        return userRepository;
    }

    private BasicAuthManager getAuthManager() throws Throwable {
        FileUserRepository userRepository = this.getUserRepository();
        BasicPasswordPolicy passwordPolicy = new BasicPasswordPolicy();
        BasicAuthManager authManager = new BasicAuthManager((UserRepository)userRepository, (PasswordPolicy)passwordPolicy, Clocks.systemClock());
        authManager.start();
        return authManager;
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("users", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("<subcommand> [<username>] [<password>] [--requires-password-change]");
        }

        public String description() {
            return "Runs several possible sub-commands for managing the native users repository: 'list', 'create', 'delete' and 'set-password'. When creating a new user, it is created with a requirement to change password on first login. Use the option --requires-password-change=false to disable this. Passing a username to the 'list' command will do a case-insensitive substring search.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new UsersCommand(homeDir, configDir, outsideWorld);
        }
    }
}

