/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.server.security.auth.exception.FormatException;
import org.neo4j.string.UTF8;

public abstract class FileRepositorySerializer<S> {
    public void saveRecordsToFile(Path recordsFile, Collection<S> records) throws IOException {
        Path directory = recordsFile.getParent();
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        Path tempFile = Files.createTempFile(directory, recordsFile.getFileName().toString() + "-", ".tmp", new FileAttribute[0]);
        try {
            Files.write(tempFile, this.serialize(records), new OpenOption[0]);
            Files.move(tempFile, recordsFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable e) {
            Files.delete(tempFile);
            throw e;
        }
    }

    public List<S> loadRecordsFromFile(Path recordsFile) throws IOException, FormatException {
        byte[] fileBytes = Files.readAllBytes(recordsFile);
        return this.deserializeRecords(fileBytes);
    }

    public byte[] serialize(Collection<S> records) {
        StringBuilder sb = new StringBuilder();
        for (S record : records) {
            sb.append(this.serialize(record)).append("\n");
        }
        return UTF8.encode((String)sb.toString());
    }

    public List<S> deserializeRecords(byte[] bytes) throws FormatException {
        ArrayList<S> out = new ArrayList<S>();
        int lineNumber = 1;
        for (String line : UTF8.decode((byte[])bytes).split("\n")) {
            if (line.trim().length() > 0) {
                out.add(this.deserializeRecord(line, lineNumber));
            }
            ++lineNumber;
        }
        return out;
    }

    protected abstract String serialize(S var1);

    protected abstract S deserializeRecord(String var1, int var2) throws FormatException;
}

