/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.exception.InvalidArgumentsException;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.User;

public class BasicAuthSubject
implements AuthSubject {
    private final BasicAuthManager authManager;
    private User user;
    private AuthenticationResult authenticationResult;
    private AccessMode.Static accessMode;

    public static BasicAuthSubject castOrFail(AuthSubject authSubject) {
        if (!(authSubject instanceof BasicAuthSubject)) {
            throw new IllegalArgumentException("Incorrect AuthSubject type " + authSubject.getClass().getTypeName());
        }
        return (BasicAuthSubject)authSubject;
    }

    public BasicAuthSubject(BasicAuthManager authManager, User user, AuthenticationResult authenticationResult) {
        this.authManager = authManager;
        this.user = user;
        this.authenticationResult = authenticationResult;
        this.accessMode = authenticationResult == AuthenticationResult.SUCCESS ? AccessMode.Static.FULL : AccessMode.Static.NONE;
    }

    public void logout() {
        this.user = null;
        this.authenticationResult = AuthenticationResult.FAILURE;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public void setPassword(String password) throws IOException, InvalidArgumentsException {
        this.authManager.setPassword(this, this.user.name(), password);
        if (this.authenticationResult == AuthenticationResult.PASSWORD_CHANGE_REQUIRED) {
            this.authenticationResult = AuthenticationResult.SUCCESS;
            this.accessMode = AccessMode.Static.FULL;
        }
    }

    public boolean doesUsernameMatch(String username) {
        return this.user.name().equals(username);
    }

    public boolean allowsReads() {
        return this.accessMode.allowsReads();
    }

    public boolean allowsWrites() {
        return this.accessMode.allowsWrites();
    }

    public boolean allowsSchemaWrites() {
        return this.accessMode.allowsSchemaWrites();
    }

    public boolean overrideOriginalMode() {
        return false;
    }

    public String name() {
        return this.accessMode.name();
    }
}

