/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.security.exception.InvalidArgumentsException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;

public abstract class AbstractUserRepository
extends LifecycleAdapter
implements UserRepository {
    protected final Map<String, User> usersByName = new ConcurrentHashMap<String, User>();
    protected volatile List<User> users = new ArrayList<User>();
    private final Pattern usernamePattern = Pattern.compile("^[a-zA-Z0-9_]+$");

    @Override
    public User getUserByName(String username) {
        return this.usersByName.get(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(User user) throws InvalidArgumentsException, IOException {
        if (!this.isValidUsername(user.name())) {
            throw new InvalidArgumentsException("'" + user.name() + "' is not a valid user name.");
        }
        AbstractUserRepository abstractUserRepository = this;
        synchronized (abstractUserRepository) {
            for (User other : this.users) {
                if (!other.name().equals(user.name())) continue;
                throw new InvalidArgumentsException("The specified user already exists");
            }
            this.users.add(user);
            this.saveUsers();
            this.usersByName.put(user.name(), user);
        }
    }

    protected abstract void saveUsers() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(User existingUser, User updatedUser) throws ConcurrentModificationException, IOException, InvalidArgumentsException {
        if (!existingUser.name().equals(updatedUser.name())) {
            throw new InvalidArgumentsException("updated user has a different name");
        }
        AbstractUserRepository abstractUserRepository = this;
        synchronized (abstractUserRepository) {
            ArrayList<User> newUsers = new ArrayList<User>();
            boolean foundUser = false;
            for (User other : this.users) {
                if (other.equals(existingUser)) {
                    foundUser = true;
                    newUsers.add(updatedUser);
                    continue;
                }
                newUsers.add(other);
            }
            if (!foundUser) {
                throw new ConcurrentModificationException();
            }
            this.users = newUsers;
            this.saveUsers();
            this.usersByName.put(updatedUser.name(), updatedUser);
        }
    }

    @Override
    public synchronized boolean delete(User user) throws IOException {
        boolean foundUser = false;
        ArrayList<User> newUsers = new ArrayList<User>();
        for (User other : this.users) {
            if (other.name().equals(user.name())) {
                foundUser = true;
                continue;
            }
            newUsers.add(other);
        }
        if (foundUser) {
            this.users = newUsers;
            this.saveUsers();
            this.usersByName.remove(user.name());
        }
        return foundUser;
    }

    @Override
    public synchronized int numberOfUsers() {
        return this.users.size();
    }

    @Override
    public boolean isValidUsername(String username) {
        return this.usernamePattern.matcher(username).matches();
    }

    @Override
    public synchronized Set<String> getAllUsernames() {
        return this.users.stream().map(User::name).collect(Collectors.toSet());
    }
}

