/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.AbstractUserRepository;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserSerialization;
import org.neo4j.server.security.auth.exception.FormatException;

public class FileUserRepository
extends AbstractUserRepository {
    private final Path authFile;
    private final Log log;
    private final UserSerialization serialization = new UserSerialization();

    public FileUserRepository(Path file, LogProvider logProvider) {
        this.authFile = file.toAbsolutePath();
        this.log = logProvider.getLog(this.getClass());
    }

    public void start() throws Throwable {
        if (Files.exists(this.authFile, new LinkOption[0])) {
            List loadedUsers;
            try {
                loadedUsers = this.serialization.loadRecordsFromFile(this.authFile);
            }
            catch (FormatException e) {
                this.log.error("Failed to read authentication file \"%s\" (%s)", new Object[]{this.authFile.toAbsolutePath(), e.getMessage()});
                throw new IllegalStateException("Failed to read authentication file: " + this.authFile);
            }
            this.users = loadedUsers;
            for (User user : this.users) {
                this.usersByName.put(user.name(), user);
            }
        }
    }

    @Override
    protected void saveUsers() throws IOException {
        this.serialization.saveRecordsToFile(this.authFile, this.users);
    }
}

