/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.time.Clock;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.exception.IllegalCredentialsException;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicAuthSubject;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.PasswordPolicy;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserManager;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;

public class BasicAuthManager
implements AuthManager,
UserManager {
    protected final AuthenticationStrategy authStrategy;
    protected final UserRepository users;
    protected final PasswordPolicy passwordPolicy;
    protected final boolean authEnabled;

    public BasicAuthManager(UserRepository users, PasswordPolicy passwordPolicy, AuthenticationStrategy authStrategy, boolean authEnabled) {
        this.users = users;
        this.passwordPolicy = passwordPolicy;
        this.authStrategy = authStrategy;
        this.authEnabled = authEnabled;
    }

    public BasicAuthManager(UserRepository users, PasswordPolicy passwordPolicy, AuthenticationStrategy authStrategy) {
        this(users, passwordPolicy, authStrategy, true);
    }

    public BasicAuthManager(UserRepository users, PasswordPolicy passwordPolicy, Clock clock, boolean authEnabled) {
        this(users, passwordPolicy, new RateLimitedAuthenticationStrategy(clock, 3), authEnabled);
    }

    public void init() throws Throwable {
        this.users.init();
    }

    public void start() throws Throwable {
        this.users.start();
        if (this.authEnabled && this.users.numberOfUsers() == 0) {
            this.newUser("neo4j", "neo4j", true);
        }
    }

    public void stop() throws Throwable {
        this.users.stop();
    }

    public void shutdown() throws Throwable {
        this.users.shutdown();
    }

    public AuthSubject login(String username, String password) {
        this.assertAuthEnabled();
        User user = this.users.findByName(username);
        AuthenticationResult result = AuthenticationResult.FAILURE;
        if (user != null && (result = this.authStrategy.authenticate(user, password)) == AuthenticationResult.SUCCESS && user.passwordChangeRequired()) {
            result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
        }
        return new BasicAuthSubject(this, user, result);
    }

    @Override
    public User newUser(String username, String initialPassword, boolean requirePasswordChange) throws IOException, IllegalCredentialsException {
        this.assertAuthEnabled();
        this.assertValidName(username);
        User user = new User.Builder().withName(username).withCredentials(Credential.forPassword(initialPassword)).withRequiredPasswordChange(requirePasswordChange).build();
        this.users.create(user);
        return user;
    }

    @Override
    public boolean deleteUser(String username) throws IOException {
        this.assertAuthEnabled();
        User user = this.users.findByName(username);
        return user != null && this.users.delete(user);
    }

    @Override
    public User getUser(String username) {
        this.assertAuthEnabled();
        return this.users.findByName(username);
    }

    public void setPassword(AuthSubject authSubject, String username, String password) throws IOException, IllegalCredentialsException {
        BasicAuthSubject basicAuthSubject = BasicAuthSubject.castOrFail(authSubject);
        if (!basicAuthSubject.doesUsernameMatch(username)) {
            throw new AuthorizationViolationException("Invalid attempt to change the password for user " + username);
        }
        this.setUserPassword(username, password);
    }

    @Override
    public void setUserPassword(String username, String password) throws IOException, IllegalCredentialsException {
        this.assertAuthEnabled();
        User existingUser = this.users.findByName(username);
        if (existingUser == null) {
            throw new IllegalCredentialsException("User " + username + " does not exist");
        }
        this.passwordPolicy.validatePassword(password);
        if (existingUser.credentials().matchesPassword(password)) {
            throw new IllegalCredentialsException("Old password and new password cannot be the same.");
        }
        try {
            User updatedUser = existingUser.augment().withCredentials(Credential.forPassword(password)).withRequiredPasswordChange(false).build();
            this.users.update(existingUser, updatedUser);
        }
        catch (ConcurrentModificationException e) {
            this.setUserPassword(username, password);
        }
    }

    protected void assertAuthEnabled() {
        if (!this.authEnabled) {
            throw new IllegalStateException("Auth not enabled");
        }
    }

    private void assertValidName(String name) {
        if (!this.users.isValidName(name)) {
            throw new IllegalArgumentException("User name contains illegal characters. Please use simple ascii characters and numbers.");
        }
    }
}

