/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.schema.SchemaValueType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;

public enum SchemaScalarValueType implements SchemaValueType
{
    BOOLEAN(ValueRepresentation.BOOLEAN, new ValueRepresentation[0]),
    BOOL(BOOLEAN),
    INTEGER(ValueRepresentation.INT64, ValueRepresentation.INT32, ValueRepresentation.INT16, ValueRepresentation.INT8),
    INT(INTEGER),
    INTEGER64(INTEGER);

    private final List<ValueRepresentation> valueRepresentations;
    private final SchemaScalarValueType delegate;

    private SchemaScalarValueType(SchemaScalarValueType delegate) {
        this.delegate = delegate;
        this.valueRepresentations = null;
    }

    private SchemaScalarValueType(ValueRepresentation valueRepresentation, ValueRepresentation ... valueRepresentations) {
        this.delegate = null;
        this.valueRepresentations = new ArrayList<ValueRepresentation>(valueRepresentations.length + 1);
        this.valueRepresentations.add(valueRepresentation);
        for (int i = 0; i < valueRepresentations.length; ++i) {
            this.valueRepresentations.add(valueRepresentations[i]);
        }
    }

    @Override
    public boolean isAssignable(Value value) {
        if (this.delegate != null) {
            return this.delegate.isAssignable(value);
        }
        return this.isAssignable(value.valueRepresentation());
    }

    boolean isAssignable(ValueRepresentation valueRepresentation) {
        for (ValueRepresentation vr : this.valueRepresentations) {
            if (vr != valueRepresentation) continue;
            return true;
        }
        return false;
    }
}

