/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

public enum IndexType {
    FULLTEXT(1),
    LOOKUP(2),
    TEXT(3),
    RANGE(4),
    POINT(5);

    private final int typeNumber;

    private IndexType(int typeNumber) {
        this.typeNumber = typeNumber;
    }

    public static IndexType fromPublicApi(org.neo4j.graphdb.schema.IndexType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case org.neo4j.graphdb.schema.IndexType.FULLTEXT -> FULLTEXT;
            case org.neo4j.graphdb.schema.IndexType.LOOKUP -> LOOKUP;
            case org.neo4j.graphdb.schema.IndexType.TEXT -> TEXT;
            case org.neo4j.graphdb.schema.IndexType.RANGE -> RANGE;
            case org.neo4j.graphdb.schema.IndexType.POINT -> POINT;
        };
    }

    public org.neo4j.graphdb.schema.IndexType toPublicApi() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FULLTEXT -> org.neo4j.graphdb.schema.IndexType.FULLTEXT;
            case LOOKUP -> org.neo4j.graphdb.schema.IndexType.LOOKUP;
            case TEXT -> org.neo4j.graphdb.schema.IndexType.TEXT;
            case RANGE -> org.neo4j.graphdb.schema.IndexType.RANGE;
            case POINT -> org.neo4j.graphdb.schema.IndexType.POINT;
        };
    }

    public boolean isLookup() {
        return this == LOOKUP;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }
}

