/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;

public class SchemaDescriptorPredicates {
    private SchemaDescriptorPredicates() {
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasLabel(int labelId) {
        return supplier -> {
            SchemaDescriptor schema = supplier.schema();
            return schema.entityType() == EntityType.NODE && ArrayUtils.contains((int[])schema.getEntityTokenIds(), (int)labelId);
        };
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasRelType(int relTypeId) {
        return supplier -> {
            SchemaDescriptor schema = supplier.schema();
            return schema.entityType() == EntityType.RELATIONSHIP && ArrayUtils.contains((int[])schema.getEntityTokenIds(), (int)relTypeId);
        };
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasProperty(int propertyId) {
        return supplier -> SchemaDescriptorPredicates.hasProperty(supplier, propertyId);
    }

    public static boolean hasLabel(SchemaDescriptorSupplier supplier, int labelId) {
        SchemaDescriptor schema = supplier.schema();
        return schema.entityType() == EntityType.NODE && ArrayUtils.contains((int[])schema.getEntityTokenIds(), (int)labelId);
    }

    public static boolean hasProperty(SchemaDescriptorSupplier supplier, int propertyId) {
        int[] schemaProperties;
        for (int schemaProp : schemaProperties = supplier.schema().getPropertyIds()) {
            if (schemaProp != propertyId) continue;
            return true;
        }
        return false;
    }
}

