/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.List;
import java.util.Optional;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaCommandUtils;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.token.TokenHolders;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SchemaCommand {
    public String name();

    public static class SchemaCommandReaderException
    extends RuntimeException {
        public SchemaCommandReaderException(String message) {
            super(message);
        }

        public SchemaCommandReaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ConstraintCommand
    extends SchemaCommand {

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface Create
        extends ConstraintCommand {
            public EntityType entityType();

            public ConstraintType constraintType();

            public boolean ifNotExists();

            public boolean hasBackingIndex();

            public ConstraintPrototype toPrototype(TokenHolders var1);

            public record RelationshipPropertyType(String name, String type, String property, PropertyTypeSet propertyTypes, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.PROPERTY_TYPE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.typeForSchema(schema, this.propertyTypes, false), List.of(this.type), List.of(this.property));
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record RelationshipKey(String name, String type, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE_EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema, this.provider);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.keyForSchema(schema, backingIndex.getIndexType()), List.of(this.type), this.properties);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record RelationshipExistence(String name, String type, String property, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.existsForSchema(schema, false), List.of(this.type), List.of(this.property));
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record RelationshipUniqueness(String name, String type, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema, this.provider);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.uniqueForSchema(schema, backingIndex.getIndexType()), List.of(this.type), this.properties);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record NodePropertyType(String name, String label, String property, PropertyTypeSet propertyTypes, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.PROPERTY_TYPE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.typeForSchema(schema, this.propertyTypes, false), List.of(this.label), List.of(this.property));
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record NodeKey(String name, String label, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE_EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema, this.provider);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.keyForSchema(schema, backingIndex.getIndexType()), List.of(this.label), this.properties);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record NodeExistence(String name, String label, String property, boolean ifNotExists) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.EXISTS;
                }

                @Override
                public boolean hasBackingIndex() {
                    return false;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property));
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.existsForSchema(schema, false), List.of(this.label), List.of(this.property));
                    return new ConstraintPrototype(constraintDescriptor);
                }
            }

            public record NodeUniqueness(String name, String label, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public ConstraintType constraintType() {
                    return ConstraintType.UNIQUE;
                }

                @Override
                public boolean hasBackingIndex() {
                    return true;
                }

                @Override
                public ConstraintPrototype toPrototype(TokenHolders tokenHolders) {
                    LabelSchemaDescriptor schema = SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertiesForName(this.properties));
                    IndexPrototype backingIndex = SchemaCommandUtils.backingIndex(schema, this.provider);
                    ConstraintDescriptor constraintDescriptor = SchemaCommandUtils.withName(this.name, ConstraintDescriptorFactory.uniqueForSchema(schema, backingIndex.getIndexType()), List.of(this.label), this.properties);
                    return new ConstraintPrototype(constraintDescriptor, backingIndex.withName(constraintDescriptor.getName()));
                }
            }

            public record ConstraintPrototype(ConstraintDescriptor descriptor, IndexPrototype backingIndex) {
                public ConstraintPrototype(ConstraintDescriptor descriptor) {
                    this(descriptor, null);
                }
            }
        }

        public record Drop(String name, boolean ifExists) implements ConstraintCommand
        {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IndexCommand
    extends SchemaCommand {

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface Create
        extends IndexCommand {
            public EntityType entityType();

            public IndexType indexType();

            public boolean ifNotExists();

            public Optional<IndexProviderDescriptor> provider();

            public IndexPrototype toPrototype(TokenHolders var1);

            public record RelationshipVector(String name, String type, String property, boolean ifNotExists, Optional<IndexProviderDescriptor> provider, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.VECTOR;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_VECTOR_DESCRIPTOR).withIndexConfig(this.config), List.of(this.type), List.of(this.property));
                }
            }

            public record NodeVector(String name, String label, String property, boolean ifNotExists, Optional<IndexProviderDescriptor> provider, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.VECTOR;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_VECTOR_DESCRIPTOR).withIndexConfig(this.config), List.of(this.label), List.of(this.property));
                }
            }

            public record RelationshipFulltext(String name, List<String> types, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.FULLTEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.fulltext(EntityType.RELATIONSHIP, tokenHolders.relationshipsForNames(this.types), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR).withIndexConfig(this.config), this.types, this.properties);
                }
            }

            public record NodeFulltext(String name, List<String> labels, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.FULLTEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.fulltext(EntityType.NODE, tokenHolders.labelsForNames(this.labels), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR).withIndexConfig(this.config), this.labels, this.properties);
                }
            }

            public record RelationshipLookup(String name, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.LOOKUP;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forAnyEntityTokens(EntityType.RELATIONSHIP), AllIndexProviderDescriptors.TOKEN_DESCRIPTOR), List.of(), List.of());
                }
            }

            public record NodeLookup(String name, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.LOOKUP;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forAnyEntityTokens(EntityType.NODE), AllIndexProviderDescriptors.TOKEN_DESCRIPTOR), List.of(), List.of());
                }
            }

            public record RelationshipPoint(String name, String type, String property, boolean ifNotExists, Optional<IndexProviderDescriptor> provider, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.POINT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.POINT_DESCRIPTOR).withIndexConfig(this.config), List.of(this.type), List.of(this.property));
                }
            }

            public record NodePoint(String name, String label, String property, boolean ifNotExists, Optional<IndexProviderDescriptor> provider, IndexConfig config) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.POINT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.POINT_DESCRIPTOR).withIndexConfig(this.config), List.of(this.label), List.of(this.property));
                }
            }

            public record RelationshipText(String name, String type, String property, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.TEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_TEXT_DESCRIPTOR), List.of(this.type), List.of(this.property));
                }
            }

            public record NodeText(String name, String label, String property, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.TEXT;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertyForName(this.property)), AllIndexProviderDescriptors.DEFAULT_TEXT_DESCRIPTOR), List.of(this.label), List.of(this.property));
                }
            }

            public record RelationshipRange(String name, String type, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.RELATIONSHIP;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.RANGE;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forRelType(tokenHolders.relationshipForName(this.type), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.RANGE_DESCRIPTOR), List.of(this.type), this.properties);
                }
            }

            public record NodeRange(String name, String label, List<String> properties, boolean ifNotExists, Optional<IndexProviderDescriptor> provider) implements Create
            {
                @Override
                public EntityType entityType() {
                    return EntityType.NODE;
                }

                @Override
                public IndexType indexType() {
                    return IndexType.RANGE;
                }

                @Override
                public IndexPrototype toPrototype(TokenHolders tokenHolders) {
                    return SchemaCommandUtils.withName(this.name, SchemaCommandUtils.forSchema(this, SchemaDescriptors.forLabel(tokenHolders.labelForName(this.label), tokenHolders.propertiesForName(this.properties)), AllIndexProviderDescriptors.RANGE_DESCRIPTOR), List.of(this.label), this.properties);
                }
            }
        }

        public record Drop(String name, boolean ifExists) implements IndexCommand
        {
        }
    }
}

