/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.lock.ResourceType;

final class NoSchemaDescriptor
implements SchemaDescriptor {
    private static final String CAST_ERROR_FMT = "NO_SCHEMA cannot be cast to a %s.";
    static final SchemaDescriptor NO_SCHEMA = new NoSchemaDescriptor();

    private NoSchemaDescriptor() {
    }

    @Override
    public <T extends SchemaDescriptor> boolean isSchemaDescriptorType(Class<T> type) {
        return false;
    }

    @Override
    public <T extends SchemaDescriptor> T asSchemaDescriptorType(Class<T> type) {
        throw new IllegalStateException(CAST_ERROR_FMT.formatted(type.getSimpleName()));
    }

    @Override
    public boolean isAffected(int[] entityIds) {
        return false;
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return "NO_SCHEMA";
    }

    @Override
    public int[] getPropertyIds() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getEntityTokenIds() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public ResourceType keyType() {
        return null;
    }

    @Override
    public EntityType entityType() {
        return null;
    }

    @Override
    public SchemaPatternMatchingType schemaPatternMatchingType() {
        return null;
    }

    @Override
    public long[] lockingKeys() {
        return ArrayUtils.EMPTY_LONG_ARRAY;
    }
}

