/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class CreateConstraintFailureException
extends SchemaKernelException {
    private final ConstraintDescriptor constraint;
    private final String cause;

    public CreateConstraintFailureException(ConstraintDescriptor constraint, Throwable cause) {
        super((Status)Status.Schema.ConstraintCreationFailed, cause, "Unable to create constraint %s: %s", constraint, cause.getMessage());
        this.constraint = constraint;
        this.cause = null;
    }

    public CreateConstraintFailureException(ConstraintDescriptor constraint, String cause) {
        super((Status)Status.Schema.ConstraintCreationFailed, null, "Unable to create constraint %s: %s", constraint, cause);
        this.constraint = constraint;
        this.cause = cause;
    }

    public ConstraintDescriptor constraint() {
        return this.constraint;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        StringBuilder sb = new StringBuilder("Unable to create ").append(this.constraint.userDescription(tokenNameLookup));
        Throwable throwable = this.getCause();
        if (throwable instanceof KernelException) {
            KernelException kernelCause = (KernelException)throwable;
            sb.append(':').append(System.lineSeparator()).append(kernelCause.getUserMessage(tokenNameLookup));
        } else if (this.cause != null) {
            sb.append(':').append(System.lineSeparator()).append(this.cause);
        }
        return sb.append(". Note that only the first found violation is shown.").toString();
    }
}

