/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexRef;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaUserDescription;

public class IndexPrototype
implements IndexRef<IndexPrototype> {
    private final SchemaDescriptor schema;
    private final boolean isUnique;
    private final IndexProviderDescriptor indexProvider;
    private final String name;
    private final IndexType indexType;
    private final IndexConfig indexConfig;

    public static IndexPrototype forSchema(SchemaDescriptor schema) {
        return new IndexPrototype(schema, false, IndexProviderDescriptor.UNDECIDED, null, IndexType.BTREE, IndexConfig.empty());
    }

    public static IndexPrototype forSchema(SchemaDescriptor schema, IndexProviderDescriptor indexProvider) {
        return new IndexPrototype(schema, false, indexProvider, null, IndexType.BTREE, IndexConfig.empty());
    }

    public static IndexPrototype uniqueForSchema(SchemaDescriptor schema) {
        return new IndexPrototype(schema, true, IndexProviderDescriptor.UNDECIDED, null, IndexType.BTREE, IndexConfig.empty());
    }

    public static IndexPrototype uniqueForSchema(SchemaDescriptor schema, IndexProviderDescriptor indexProvider) {
        return new IndexPrototype(schema, true, indexProvider, null, IndexType.BTREE, IndexConfig.empty());
    }

    private IndexPrototype(SchemaDescriptor schema, boolean isUnique, IndexProviderDescriptor indexProvider, String name, IndexType indexType, IndexConfig indexConfig) {
        Objects.requireNonNull(schema, "Schema of index cannot be null.");
        Objects.requireNonNull(indexProvider, "Index provider cannot be null.");
        Objects.requireNonNull(indexType, "Index type cannot be null.");
        Objects.requireNonNull(indexConfig, "Index configuration cannot be null.");
        this.schema = schema;
        this.isUnique = isUnique;
        this.indexProvider = indexProvider;
        this.name = name;
        this.indexType = indexType;
        this.indexConfig = indexConfig;
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return SchemaUserDescription.forPrototype(tokenNameLookup, this.name, this.isUnique, this.indexType, this.schema(), this.getIndexProvider());
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public IndexProviderDescriptor getIndexProvider() {
        return this.indexProvider;
    }

    @Override
    public IndexPrototype withIndexProvider(IndexProviderDescriptor indexProvider) {
        return new IndexPrototype(this.schema, this.isUnique, indexProvider, this.name, this.indexType, this.indexConfig);
    }

    @Override
    public IndexPrototype withSchemaDescriptor(SchemaDescriptor schema) {
        return new IndexPrototype(schema, this.isUnique, this.indexProvider, this.name, this.indexType, this.indexConfig);
    }

    @Override
    public IndexConfig getIndexConfig() {
        return this.indexConfig;
    }

    @Override
    public IndexPrototype withIndexConfig(IndexConfig indexConfig) {
        if (indexConfig == null) {
            return this;
        }
        return new IndexPrototype(this.schema, this.isUnique, this.indexProvider, this.name, this.indexType, indexConfig);
    }

    public IndexPrototype withName(String name) {
        if (name == null) {
            return this;
        }
        return new IndexPrototype(this.schema, this.isUnique, this.indexProvider, name, this.indexType, this.indexConfig);
    }

    public IndexPrototype withIndexType(IndexType indexType) {
        if (indexType == null) {
            return this;
        }
        return new IndexPrototype(this.schema, this.isUnique, this.indexProvider, this.name, indexType, this.indexConfig);
    }

    public IndexDescriptor materialise(long id) {
        return new IndexDescriptor(id, this);
    }
}

