/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.function.Predicate;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.NoSchemaDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorImplementation;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaProcessor;
import org.neo4j.lock.ResourceType;

public interface SchemaDescriptor
extends SchemaDescriptorSupplier {
    public static SchemaDescriptor noSchema() {
        return NoSchemaDescriptor.NO_SCHEMA;
    }

    public static FulltextSchemaDescriptor fulltext(EntityType entityType, int[] entityTokenIds, int[] propertyKeyIds) {
        return new SchemaDescriptorImplementation(entityType, PropertySchemaType.PARTIAL_ANY_TOKEN, entityTokenIds, propertyKeyIds);
    }

    public static LabelSchemaDescriptor forLabel(int labelId, int ... propertyIds) {
        SchemaDescriptor.validateLabelIds(labelId);
        SchemaDescriptor.validatePropertyIds(propertyIds);
        return new SchemaDescriptorImplementation(EntityType.NODE, PropertySchemaType.COMPLETE_ALL_TOKENS, new int[]{labelId}, propertyIds);
    }

    public static RelationTypeSchemaDescriptor forRelType(int relTypeId, int ... propertyIds) {
        SchemaDescriptor.validateRelationshipTypeIds(relTypeId);
        SchemaDescriptor.validatePropertyIds(propertyIds);
        return new SchemaDescriptorImplementation(EntityType.RELATIONSHIP, PropertySchemaType.COMPLETE_ALL_TOKENS, new int[]{relTypeId}, propertyIds);
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> equalTo(SchemaDescriptor descriptor) {
        return supplier -> descriptor.equals(supplier.schema());
    }

    private static void validatePropertyIds(int[] propertyIds) {
        for (int propertyId : propertyIds) {
            if (-1 != propertyId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent property.");
        }
    }

    private static void validateRelationshipTypeIds(int ... relTypes) {
        for (int relType : relTypes) {
            if (-1 != relType) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent relationship type.");
        }
    }

    private static void validateLabelIds(int ... labelIds) {
        for (int labelId : labelIds) {
            if (-1 != labelId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent label.");
        }
    }

    private static long[] schemaTokenLockingIds(SchemaDescriptor schema) {
        int[] tokenIds = schema.getEntityTokenIds();
        int length = tokenIds.length;
        long[] lockingIds = new long[length];
        for (int i = 0; i < length; ++i) {
            lockingIds[i] = tokenIds[i];
        }
        return lockingIds;
    }

    public boolean isLabelSchemaDescriptor();

    public LabelSchemaDescriptor asLabelSchemaDescriptor();

    public boolean isRelationshipTypeSchemaDescriptor();

    public RelationTypeSchemaDescriptor asRelationshipTypeSchemaDescriptor();

    public boolean isFulltextSchemaDescriptor();

    public FulltextSchemaDescriptor asFulltextSchemaDescriptor();

    public boolean isAffected(long[] var1);

    public void processWith(SchemaProcessor var1);

    public int[] getPropertyIds();

    default public int getPropertyId() {
        int[] propertyIds = this.getPropertyIds();
        if (propertyIds.length != 1) {
            throw new IllegalStateException("Single property schema requires one property but had " + propertyIds.length);
        }
        return propertyIds[0];
    }

    public int[] getEntityTokenIds();

    default public int getLabelId() {
        if (this.entityType() != EntityType.NODE) {
            throw new IllegalStateException("Cannot get label id from a schema on " + this.entityType() + " entities.");
        }
        int[] entityTokenIds = this.getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IllegalStateException("Cannot get a single label id from a multi-token schema descriptor: " + this);
        }
        return entityTokenIds[0];
    }

    default public int getRelTypeId() {
        if (this.entityType() != EntityType.RELATIONSHIP) {
            throw new IllegalStateException("Cannot get relationship type id from a schema on " + this.entityType() + " entities.");
        }
        int[] entityTokenIds = this.getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IllegalStateException("Cannot get a single relationship type id from a multi-token schema descriptor: " + this);
        }
        return entityTokenIds[0];
    }

    default public long[] lockingKeys() {
        return SchemaDescriptor.schemaTokenLockingIds(this);
    }

    public ResourceType keyType();

    public EntityType entityType();

    public PropertySchemaType propertySchemaType();
}

