/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexRef;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.ReservedSchemaRuleNames;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaUserDescription;

public final class IndexDescriptor
implements IndexRef<IndexDescriptor>,
SchemaRule {
    public static final IndexDescriptor NO_INDEX = new IndexDescriptor();
    private final long id;
    private final String name;
    private final SchemaDescriptor schema;
    private final boolean isUnique;
    private final IndexProviderDescriptor indexProvider;
    private final Long owningConstraintId;
    private final IndexCapability capability;
    private final IndexType indexType;
    private final IndexConfig indexConfig;

    IndexDescriptor(long id, IndexPrototype prototype) {
        this(id, SchemaRule.sanitiseName(prototype.getName()), prototype.schema(), prototype.isUnique(), prototype.getIndexProvider(), null, IndexCapability.NO_CAPABILITY, prototype.getIndexType(), prototype.getIndexConfig());
    }

    private IndexDescriptor(long id, String name, SchemaDescriptor schema, boolean isUnique, IndexProviderDescriptor indexProvider, Long owningConstraintId, IndexCapability capability, IndexType indexType, IndexConfig indexConfig) {
        if (id < 0L) {
            throw new IllegalArgumentException("The id of an index must not be negative, but it was attempted to assign " + id + ".");
        }
        name = SchemaRule.sanitiseName(name);
        Objects.requireNonNull(schema, "The schema of an index cannot be null.");
        Objects.requireNonNull(indexProvider, "The index provider cannot be null.");
        Objects.requireNonNull(capability, "The index capability cannot be null.");
        Objects.requireNonNull(indexConfig, "The index configuration cannot be null.");
        this.id = id;
        this.name = name;
        this.schema = schema;
        this.isUnique = isUnique;
        this.indexProvider = indexProvider;
        this.owningConstraintId = owningConstraintId;
        this.capability = capability;
        this.indexType = indexType;
        this.indexConfig = indexConfig;
    }

    private IndexDescriptor() {
        this.id = -1L;
        this.name = ReservedSchemaRuleNames.NO_INDEX.getReservedName();
        this.schema = SchemaDescriptor.noSchema();
        this.isUnique = false;
        this.indexProvider = IndexProviderDescriptor.UNDECIDED;
        this.owningConstraintId = null;
        this.capability = IndexCapability.NO_CAPABILITY;
        this.indexType = IndexType.BTREE;
        this.indexConfig = IndexConfig.empty();
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IndexDescriptor withName(String name) {
        if (name == null) {
            return this;
        }
        name = SchemaRule.sanitiseName(name);
        return new IndexDescriptor(this.id, name, this.schema, this.isUnique, this.indexProvider, this.owningConstraintId, this.capability, this.indexType, this.indexConfig);
    }

    @Override
    public IndexConfig getIndexConfig() {
        return this.indexConfig;
    }

    @Override
    public IndexDescriptor withIndexConfig(IndexConfig indexConfig) {
        return new IndexDescriptor(this.id, this.name, this.schema, this.isUnique, this.indexProvider, this.owningConstraintId, this.capability, this.indexType, indexConfig);
    }

    public OptionalLong getOwningConstraintId() {
        return this.owningConstraintId == null ? OptionalLong.empty() : OptionalLong.of(this.owningConstraintId);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return SchemaUserDescription.forIndex(tokenNameLookup, this.id, this.name, this.isUnique, this.indexType, this.schema(), this.getIndexProvider());
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public IndexProviderDescriptor getIndexProvider() {
        return this.indexProvider;
    }

    public IndexCapability getCapability() {
        return this.capability;
    }

    @Override
    public IndexDescriptor withIndexProvider(IndexProviderDescriptor indexProvider) {
        return new IndexDescriptor(this.id, this.name, this.schema, this.isUnique, indexProvider, this.owningConstraintId, this.capability, this.indexType, this.indexConfig);
    }

    @Override
    public IndexDescriptor withSchemaDescriptor(SchemaDescriptor schema) {
        return new IndexDescriptor(this.id, this.name, schema, this.isUnique, this.indexProvider, this.owningConstraintId, this.capability, this.indexType, this.indexConfig);
    }

    public IndexDescriptor withOwningConstraintId(long owningConstraintId) {
        if (!this.isUnique()) {
            throw new IllegalStateException("Cannot assign an owning constraint id (in this case " + owningConstraintId + ") to a non-unique index: " + this + ".");
        }
        if (owningConstraintId < 0L) {
            throw new IllegalArgumentException("The owning constraint id of an index must not be negative, but it was attempted to assign " + owningConstraintId + ".");
        }
        return new IndexDescriptor(this.id, this.name, this.schema, this.isUnique, this.indexProvider, owningConstraintId, this.capability, this.indexType, this.indexConfig);
    }

    public IndexDescriptor withIndexCapability(IndexCapability capability) {
        return new IndexDescriptor(this.id, this.name, this.schema, this.isUnique, this.indexProvider, this.owningConstraintId, capability, this.indexType, this.indexConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexDescriptor that = (IndexDescriptor)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.isUnique != that.isUnique) {
            return false;
        }
        if (this.indexType != that.indexType) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.schema.equals(that.schema)) {
            return false;
        }
        return this.indexProvider.equals(that.indexProvider);
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public static Iterator<IndexDescriptor> sortByType(Iterator<IndexDescriptor> indexes) {
        ArrayList nonUnique = new ArrayList();
        ArrayList unique = new ArrayList();
        indexes.forEachRemaining(index -> (index.isUnique() ? unique : nonUnique).add(index));
        return Stream.concat(nonUnique.stream(), unique.stream()).iterator();
    }
}

