/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaProcessor;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.token.api.TokenIdPrettyPrinter;

public final class SchemaDescriptorImplementation
implements SchemaDescriptor,
LabelSchemaDescriptor,
RelationTypeSchemaDescriptor,
FulltextSchemaDescriptor {
    private final EntityType entityType;
    private final PropertySchemaType propertySchemaType;
    private final int[] entityTokens;
    private final int[] propertyKeyIds;
    private final boolean archetypalLabelSchema;
    private final boolean archetypalRelationshipTypeSchema;
    private final boolean archetypalFulltextSchema;

    public SchemaDescriptorImplementation(EntityType entityType, PropertySchemaType propertySchemaType, int[] entityTokens, int[] propertyKeyIds) {
        this.entityType = Objects.requireNonNull(entityType, "EntityType cannot be null.");
        this.propertySchemaType = Objects.requireNonNull(propertySchemaType, "PropertySchemaType cannot be null.");
        this.entityTokens = Objects.requireNonNull(entityTokens, "Entity tokens array cannot be null.");
        this.propertyKeyIds = Objects.requireNonNull(propertyKeyIds, "Property key ids array cannot be null.");
        if (entityTokens.length == 0) {
            throw new IllegalArgumentException("Schema descriptor must have at least one " + (entityType == EntityType.NODE ? "label." : "relationship type."));
        }
        if (propertyKeyIds.length == 0) {
            throw new IllegalArgumentException("Schema descriptor must have at least one property key id.");
        }
        switch (entityType) {
            case NODE: {
                SchemaDescriptorImplementation.validateLabelIds(entityTokens);
                break;
            }
            case RELATIONSHIP: {
                SchemaDescriptorImplementation.validateRelationshipTypeIds(entityTokens);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown entity type: " + entityType + ".");
            }
        }
        SchemaDescriptorImplementation.validatePropertyIds(propertyKeyIds);
        boolean generalSingleEntity = entityTokens.length == 1 && propertySchemaType == PropertySchemaType.COMPLETE_ALL_TOKENS;
        this.archetypalLabelSchema = entityType == EntityType.NODE && generalSingleEntity;
        this.archetypalRelationshipTypeSchema = entityType == EntityType.RELATIONSHIP && generalSingleEntity;
        this.archetypalFulltextSchema = propertySchemaType == PropertySchemaType.PARTIAL_ANY_TOKEN;
    }

    private static void validatePropertyIds(int ... propertyIds) {
        for (int propertyId : propertyIds) {
            if (-1 != propertyId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent property.");
        }
    }

    private static void validateRelationshipTypeIds(int ... relTypes) {
        for (int relType : relTypes) {
            if (-1 != relType) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent relationship type.");
        }
    }

    private static void validateLabelIds(int ... labelIds) {
        for (int labelId : labelIds) {
            if (-1 != labelId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent label.");
        }
    }

    @Override
    public boolean isLabelSchemaDescriptor() {
        return this.archetypalLabelSchema;
    }

    @Override
    public LabelSchemaDescriptor asLabelSchemaDescriptor() {
        if (!this.archetypalLabelSchema) {
            throw this.cannotCastException("LabelSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isRelationshipTypeSchemaDescriptor() {
        return this.archetypalRelationshipTypeSchema;
    }

    @Override
    public RelationTypeSchemaDescriptor asRelationshipTypeSchemaDescriptor() {
        if (!this.archetypalRelationshipTypeSchema) {
            throw this.cannotCastException("RelationTypeSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isFulltextSchemaDescriptor() {
        return this.archetypalFulltextSchema;
    }

    @Override
    public FulltextSchemaDescriptor asFulltextSchemaDescriptor() {
        if (!this.archetypalFulltextSchema) {
            throw this.cannotCastException("FulltextSchemaDescriptor");
        }
        return this;
    }

    private IllegalStateException cannotCastException(String descriptorType) {
        return new IllegalStateException("Cannot cast this schema to a " + descriptorType + " because it does not match that structure: " + this + ".");
    }

    @Override
    public boolean isAffected(long[] entityTokenIds) {
        for (int id : this.entityTokens) {
            if (!ArrayUtils.contains((long[])entityTokenIds, (long)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processWith(SchemaProcessor processor) {
        if (this.archetypalLabelSchema) {
            processor.processSpecific(this.asLabelSchemaDescriptor());
        } else if (this.archetypalRelationshipTypeSchema) {
            processor.processSpecific(this.asRelationshipTypeSchemaDescriptor());
        } else {
            processor.processSpecific((SchemaDescriptor)this);
        }
    }

    public String toString() {
        return "SchemaDescriptor[" + this.userDescription(TokenNameLookup.idTokenNameLookup) + "]";
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        String suffix;
        String prefix = this.entityType == EntityType.RELATIONSHIP ? "-[" : "";
        String string = suffix = this.entityType == EntityType.RELATIONSHIP ? "]-" : "";
        IntFunction<String> lookup = this.entityType == EntityType.NODE ? arg_0 -> ((TokenNameLookup)tokenNameLookup).labelGetName(arg_0) : arg_0 -> ((TokenNameLookup)tokenNameLookup).relationshipTypeGetName(arg_0);
        return prefix + TokenIdPrettyPrinter.niceEntityLabels(lookup, (int[])this.entityTokens) + TokenIdPrettyPrinter.niceProperties((TokenNameLookup)tokenNameLookup, (int[])this.propertyKeyIds) + suffix;
    }

    @Override
    public int[] getPropertyIds() {
        return this.propertyKeyIds;
    }

    @Override
    public int[] getEntityTokenIds() {
        return this.entityTokens;
    }

    @Override
    public ResourceType keyType() {
        return this.entityType == EntityType.NODE ? ResourceTypes.LABEL : ResourceTypes.RELATIONSHIP_TYPE;
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public PropertySchemaType propertySchemaType() {
        return this.propertySchemaType;
    }

    @Override
    public SchemaDescriptor schema() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDescriptor)) {
            return false;
        }
        SchemaDescriptor that = (SchemaDescriptor)o;
        return this.entityType == that.entityType() && this.propertySchemaType == that.propertySchemaType() && Arrays.equals(this.entityTokens, that.getEntityTokenIds()) && Arrays.equals(this.propertyKeyIds, that.getPropertyIds());
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.entityType, this.propertySchemaType});
        result = 31 * result + Arrays.hashCode(this.entityTokens);
        result = 31 * result + Arrays.hashCode(this.propertyKeyIds);
        return result;
    }
}

