/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.NodeLabelExistenceSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeLabelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.string.Mask;

final class NodeLabelExistenceConstraintDescriptorImplementation
implements NodeLabelExistenceConstraintDescriptor {
    private final long id;
    private final String name;
    private final NodeLabelExistenceSchemaDescriptor schema;
    private final int requiredLabelId;

    NodeLabelExistenceConstraintDescriptorImplementation(NodeLabelExistenceSchemaDescriptor schema, long id, int requiredLabelId, String name) {
        if (requiredLabelId < 0) {
            throw new IllegalArgumentException("requiredLabelId cannot be negative");
        }
        this.schema = Objects.requireNonNull(schema, "NodeLabelExistenceSchemaDescriptor cannot be null");
        if (requiredLabelId == schema.getLabelId()) {
            throw new IllegalArgumentException("requiredLabelId cannot be same as schema labelId");
        }
        this.requiredLabelId = requiredLabelId;
        this.id = id;
        this.name = name;
    }

    static NodeLabelExistenceConstraintDescriptor make(NodeLabelExistenceSchemaDescriptor schema, int requiredLabelId) {
        return new NodeLabelExistenceConstraintDescriptorImplementation(schema, -1L, requiredLabelId, null);
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public ConstraintType type() {
        return ConstraintType.NODE_LABEL_EXISTENCE;
    }

    @Override
    public GraphTypeDependence graphTypeDependence() {
        return GraphTypeDependence.DEPENDENT;
    }

    @Override
    public boolean enforcesUniqueness() {
        return false;
    }

    @Override
    public boolean enforcesPropertyExistence() {
        return false;
    }

    @Override
    public boolean enforcesPropertyType() {
        return false;
    }

    @Override
    public boolean isPropertyTypeConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipEndpointLabelConstraint() {
        return false;
    }

    @Override
    public boolean isNodeLabelExistenceConstraint() {
        return true;
    }

    @Override
    public boolean isNodePropertyTypeConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipPropertyTypeConstraint() {
        return false;
    }

    @Override
    public TypeConstraintDescriptor asPropertyTypeConstraint() {
        throw this.conversionException(TypeConstraintDescriptor.class);
    }

    @Override
    public boolean isPropertyExistenceConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipPropertyExistenceConstraint() {
        return false;
    }

    @Override
    public boolean isNodePropertyExistenceConstraint() {
        return false;
    }

    @Override
    public ExistenceConstraintDescriptor asPropertyExistenceConstraint() {
        throw this.conversionException(ExistenceConstraintDescriptor.class);
    }

    @Override
    public boolean isUniquenessConstraint() {
        return false;
    }

    @Override
    public boolean isNodeUniquenessConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipUniquenessConstraint() {
        return false;
    }

    @Override
    public UniquenessConstraintDescriptor asUniquenessConstraint() {
        throw this.conversionException(UniquenessConstraintDescriptor.class);
    }

    @Override
    public boolean isNodeKeyConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipKeyConstraint() {
        return false;
    }

    @Override
    public boolean isIndexBackedConstraint() {
        return false;
    }

    @Override
    public IndexBackedConstraintDescriptor asIndexBackedConstraint() {
        throw this.conversionException(IndexBackedConstraintDescriptor.class);
    }

    @Override
    public boolean isKeyConstraint() {
        return false;
    }

    @Override
    public KeyConstraintDescriptor asKeyConstraint() {
        throw this.conversionException(KeyConstraintDescriptor.class);
    }

    @Override
    public NodeLabelExistenceConstraintDescriptor withId(long newId) {
        return new NodeLabelExistenceConstraintDescriptorImplementation(this.schema, newId, this.requiredLabelId, this.name);
    }

    @Override
    public NodeLabelExistenceConstraintDescriptor withName(String newName) {
        if (newName == null) {
            return this;
        }
        newName = SchemaNameUtil.sanitiseName(newName);
        return new NodeLabelExistenceConstraintDescriptorImplementation(this.schema, this.id, this.requiredLabelId, newName);
    }

    @Override
    public IndexBackedConstraintDescriptor withOwnedIndexId(long id) {
        throw new NotImplementedException();
    }

    @Override
    public RelationshipEndpointLabelConstraintDescriptor asRelationshipEndpointLabelConstraint() {
        throw this.conversionException(RelationshipEndpointLabelConstraintDescriptor.class);
    }

    @Override
    public NodeLabelExistenceConstraintDescriptor asNodeLabelExistenceConstraint() {
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeLabelExistenceConstraintDescriptor)) {
            return false;
        }
        NodeLabelExistenceConstraintDescriptor that = (NodeLabelExistenceConstraintDescriptor)o;
        return this.equalsIgnoreName(that) && Objects.equals(this.name, that.getName());
    }

    @Override
    public boolean equalsIgnoreName(ConstraintDescriptor that) {
        if (!that.isNodeLabelExistenceConstraint()) {
            return false;
        }
        if (this.requiredLabelId != that.asNodeLabelExistenceConstraint().requiredLabelId()) {
            return false;
        }
        return this.schema().equals(that.schema());
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.requiredLabelId, this.name);
    }

    @Override
    public boolean conflictsWith(ConstraintDescriptor other) {
        if (other.isNodeLabelExistenceConstraint()) {
            NodeLabelExistenceConstraintDescriptor that = other.asNodeLabelExistenceConstraint();
            return this.schema().getLabelId() == that.requiredLabelId() || this.requiredLabelId() == that.schema().getLabelId();
        }
        return false;
    }

    @Override
    public long getId() {
        if (this.id == -1L) {
            throw new IllegalStateException("This constraint descriptor have no id assigned: " + String.valueOf(this));
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int requiredLabelId() {
        return this.requiredLabelId;
    }

    @Override
    public int schemaLabelId() {
        return this.schema.getLabelId();
    }

    public String toString() {
        return this.toString(Mask.NO);
    }

    public String toString(Mask mask) {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, mask);
    }

    private String userDescription(TokenNameLookup tokenNameLookup, Mask mask) {
        return SchemaUserDescription.forConstraint(tokenNameLookup, this.id, this.name, ConstraintType.NODE_LABEL_EXISTENCE, this.schema, null, null, tokenNameLookup.labelGetName(this.requiredLabelId), null, mask);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return this.userDescription(tokenNameLookup, Mask.NO);
    }

    private IllegalStateException conversionException(Class<? extends ConstraintDescriptor> targetType) {
        return new IllegalStateException("Cannot cast this schema to a " + String.valueOf(targetType) + " because it does not match that structure: " + String.valueOf(this) + ".");
    }
}

