/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.Status;

public class SchemaRuleNotFoundException
extends SchemaRuleException {
    private static final String NOT_FOUND_MESSAGE_TEMPLATE = "No %s was found for %s.";

    private SchemaRuleNotFoundException(ErrorGqlStatusObject gqlStatusObject, SchemaDescriptorSupplier schemaThing, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (Status)Status.Schema.SchemaRuleAccessFailed, NOT_FOUND_MESSAGE_TEMPLATE, schemaThing, tokenNameLookup);
    }

    public static SchemaRuleNotFoundException schemaRuleNotFound(SchemaDescriptorSupplier schemaThing, TokenNameLookup tokenNameLookup) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N21).withParam(GqlParams.StringParam.schemaDescrType, SchemaRuleException.describe(schemaThing)).withParam(GqlParams.StringParam.schemaDescr, schemaThing.schema().userDescription(tokenNameLookup)).build();
        return new SchemaRuleNotFoundException(gql, schemaThing, tokenNameLookup);
    }

    public static SchemaRuleNotFoundException schemaRuleNotFound(SchemaDescriptor schema, TokenNameLookup tokenNameLookup) {
        return SchemaRuleNotFoundException.schemaRuleNotFound(() -> schema, tokenNameLookup);
    }
}

