/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Resource;

public class ResourceUtils {
    public static <T extends Resource> void closeAll(Iterable<T> resources) {
        ResourceUtils.closeAll(StreamSupport.stream(resources.spliterator(), false));
    }

    @SafeVarargs
    public static <T extends Resource> void closeAll(T ... resources) {
        ResourceUtils.closeAll(Arrays.stream(resources));
    }

    public static <T extends Resource> void closeAll(Stream<T> resources) {
        resources.filter(Objects::nonNull).forEach(Resource::close);
    }
}

