/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.ExtremeValuesLibrary;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public enum ValueType {
    BOOLEAN(ValueGroup.BOOLEAN, BooleanValue.class, ExtremeValuesLibrary.EXTREME_BOOLEAN),
    BYTE(ValueGroup.NUMBER, ByteValue.class, ExtremeValuesLibrary.EXTREME_BYTE),
    SHORT(ValueGroup.NUMBER, ShortValue.class, ExtremeValuesLibrary.EXTREME_SHORT),
    INT(ValueGroup.NUMBER, IntValue.class, ExtremeValuesLibrary.EXTREME_INT),
    LONG(ValueGroup.NUMBER, LongValue.class, ExtremeValuesLibrary.EXTREME_LONG),
    FLOAT(ValueGroup.NUMBER, FloatValue.class, ExtremeValuesLibrary.EXTREME_FLOAT),
    DOUBLE(ValueGroup.NUMBER, DoubleValue.class, ExtremeValuesLibrary.EXTREME_DOUBLE),
    CHAR(ValueGroup.TEXT, CharValue.class, ExtremeValuesLibrary.EXTREME_CHAR),
    STRING(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING),
    STRING_ALPHANUMERIC(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_ALPHANUMERIC),
    STRING_ASCII(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_ASCII),
    STRING_BMP(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_BMP),
    LOCAL_DATE_TIME(ValueGroup.LOCAL_DATE_TIME, LocalDateTimeValue.class, ExtremeValuesLibrary.EXTREME_LOCAL_DATE_TIME),
    DATE(ValueGroup.DATE, DateValue.class, ExtremeValuesLibrary.EXTREME_DATE),
    LOCAL_TIME(ValueGroup.LOCAL_TIME, LocalTimeValue.class, ExtremeValuesLibrary.EXTREME_LOCAL_TIME),
    PERIOD(ValueGroup.DURATION, DurationValue.class, ExtremeValuesLibrary.EXTREME_PERIOD),
    DURATION(ValueGroup.DURATION, DurationValue.class, ExtremeValuesLibrary.EXTREME_DURATION),
    TIME(ValueGroup.ZONED_TIME, TimeValue.class, ExtremeValuesLibrary.EXTREME_TIME),
    DATE_TIME(ValueGroup.ZONED_DATE_TIME, DateTimeValue.class, ExtremeValuesLibrary.EXTREME_DATE_TIME),
    CARTESIAN_POINT(ValueGroup.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT),
    CARTESIAN_POINT_3D(ValueGroup.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT_3D),
    GEOGRAPHIC_POINT(ValueGroup.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT),
    GEOGRAPHIC_POINT_3D(ValueGroup.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT_3D),
    BOOLEAN_ARRAY(ValueGroup.BOOLEAN_ARRAY, BooleanArray.class, true, ExtremeValuesLibrary.EXTREME_BOOLEAN_ARRAY),
    BYTE_ARRAY(ValueGroup.NUMBER_ARRAY, ByteArray.class, true, ExtremeValuesLibrary.EXTREME_BYTE_ARRAY),
    SHORT_ARRAY(ValueGroup.NUMBER_ARRAY, ShortArray.class, true, ExtremeValuesLibrary.EXTREME_SHORT_ARRAY),
    INT_ARRAY(ValueGroup.NUMBER_ARRAY, IntArray.class, true, ExtremeValuesLibrary.EXTREME_INT_ARRAY),
    LONG_ARRAY(ValueGroup.NUMBER_ARRAY, LongArray.class, true, ExtremeValuesLibrary.EXTREME_LONG_ARRAY),
    FLOAT_ARRAY(ValueGroup.NUMBER_ARRAY, FloatArray.class, true, ExtremeValuesLibrary.EXTREME_FLOAT_ARRAY),
    DOUBLE_ARRAY(ValueGroup.NUMBER_ARRAY, DoubleArray.class, true, ExtremeValuesLibrary.EXTREME_DOUBLE_ARRAY),
    CHAR_ARRAY(ValueGroup.TEXT_ARRAY, CharArray.class, true, ExtremeValuesLibrary.EXTREME_CHAR_ARRAY),
    STRING_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ARRAY),
    STRING_ALPHANUMERIC_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ALPHANUMERIC_ARRAY),
    STRING_ASCII_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ASCII_ARRAY),
    STRING_BMP_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_BMP_ARRAY),
    LOCAL_DATE_TIME_ARRAY(ValueGroup.LOCAL_DATE_TIME_ARRAY, LocalDateTimeArray.class, true, ExtremeValuesLibrary.EXTREME_LOCAL_DATE_TIME_ARRAY),
    DATE_ARRAY(ValueGroup.DATE_ARRAY, DateArray.class, true, ExtremeValuesLibrary.EXTREME_DATE_ARRAY),
    LOCAL_TIME_ARRAY(ValueGroup.LOCAL_TIME_ARRAY, LocalTimeArray.class, true, ExtremeValuesLibrary.EXTREME_LOCAL_TIME_ARRAY),
    PERIOD_ARRAY(ValueGroup.DURATION_ARRAY, DurationArray.class, true, ExtremeValuesLibrary.EXTREME_PERIOD_ARRAY),
    DURATION_ARRAY(ValueGroup.DURATION_ARRAY, DurationArray.class, true, ExtremeValuesLibrary.EXTREME_DURATION_ARRAY),
    TIME_ARRAY(ValueGroup.ZONED_TIME_ARRAY, TimeArray.class, true, ExtremeValuesLibrary.EXTREME_TIME_ARRAY),
    DATE_TIME_ARRAY(ValueGroup.ZONED_DATE_TIME_ARRAY, DateTimeArray.class, true, ExtremeValuesLibrary.EXTREME_DATE_TIME_ARRAY),
    CARTESIAN_POINT_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT_ARRAY),
    CARTESIAN_POINT_3D_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT_3D_ARRAY),
    GEOGRAPHIC_POINT_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT_ARRAY),
    GEOGRAPHIC_POINT_3D_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT_3D_ARRAY);

    public final ValueGroup valueGroup;
    public final Class<? extends Value> valueClass;
    public final boolean arrayType;
    private final Value[] extremeValues;

    private ValueType(ValueGroup valueGroup, Class<? extends Value> valueClass, Value ... extremeValues) {
        this(valueGroup, valueClass, false, extremeValues);
    }

    private ValueType(ValueGroup valueGroup, Class<? extends Value> valueClass, boolean arrayType, Value ... extremeValues) {
        this.valueGroup = valueGroup;
        this.valueClass = valueClass;
        this.arrayType = arrayType;
        this.extremeValues = extremeValues;
    }

    public Value[] extremeValues() {
        return this.extremeValues;
    }

    static ValueType[] arrayTypes() {
        return (ValueType[])Arrays.stream(ValueType.values()).filter(t -> t.arrayType).toArray(ValueType[]::new);
    }
}

