/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.Generator;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomGenerator;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.SplittableRandomGenerator;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.UTF8StringValueBuilder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RandomValues {
    public static final int MAX_16_BIT_CODE_POINT = 65535;
    public static Configuration DEFAULT_CONFIGURATION = new Default();
    private static Types[] TYPES = Types.values();
    private static final long NANOS_PER_SECOND = 1000000000L;
    private final Generator generator;
    private final Configuration configuration;

    private RandomValues(Generator generator) {
        this(generator, DEFAULT_CONFIGURATION);
    }

    private RandomValues(Generator generator, Configuration configuration) {
        this.generator = generator;
        this.configuration = configuration;
    }

    public static RandomValues create() {
        return new RandomValues(new RandomGenerator(ThreadLocalRandom.current()));
    }

    public static RandomValues create(Configuration configuration) {
        return new RandomValues(new RandomGenerator(ThreadLocalRandom.current()), configuration);
    }

    public static RandomValues create(Random random, Configuration configuration) {
        return new RandomValues(new RandomGenerator(random), configuration);
    }

    public static RandomValues create(Random random) {
        return new RandomValues(new RandomGenerator(random));
    }

    public static RandomValues create(SplittableRandom random, Configuration configuration) {
        return new RandomValues(new SplittableRandomGenerator(random), configuration);
    }

    public static RandomValues create(SplittableRandom random) {
        return new RandomValues(new SplittableRandomGenerator(random));
    }

    public LongValue nextLongValue() {
        return Values.longValue((long)this.generator.nextLong());
    }

    public LongValue nextLongValue(long bound) {
        return Values.longValue((long)this.nextLong(bound));
    }

    public LongValue nextLongValue(long lower, long upper) {
        return Values.longValue((long)(this.nextLong(upper - lower + 1L) + lower));
    }

    public BooleanValue nextBooleanValue() {
        return Values.booleanValue((boolean)this.generator.nextBoolean());
    }

    public boolean nextBoolean() {
        return this.generator.nextBoolean();
    }

    public IntValue nextIntValue() {
        return Values.intValue((int)this.generator.nextInt());
    }

    public int nextInt() {
        return this.generator.nextInt();
    }

    public IntValue nextIntValue(int bound) {
        return Values.intValue((int)this.generator.nextInt(bound));
    }

    public int nextInt(int bound) {
        return this.generator.nextInt(bound);
    }

    public ShortValue nextShortValue() {
        return Values.shortValue((short)((short)this.generator.nextInt()));
    }

    public ShortValue nextShortValue(short bound) {
        return Values.shortValue((short)((short)this.generator.nextInt(bound)));
    }

    public ByteValue nextByteValue() {
        return Values.byteValue((byte)((byte)this.generator.nextInt()));
    }

    public ByteValue nextByteValue(byte bound) {
        return Values.byteValue((byte)((byte)this.generator.nextInt(bound)));
    }

    public FloatValue nextFloatValue() {
        return Values.floatValue((float)this.generator.nextFloat());
    }

    public float nextFloat() {
        return this.generator.nextFloat();
    }

    public DoubleValue nextDoubleValue() {
        return Values.doubleValue((double)this.generator.nextDouble());
    }

    public NumberValue nextNumberValue() {
        int type = this.generator.nextInt(6);
        switch (type) {
            case 0: {
                return this.nextByteValue();
            }
            case 1: {
                return this.nextShortValue();
            }
            case 2: {
                return this.nextIntValue();
            }
            case 3: {
                return this.nextLongValue();
            }
            case 4: {
                return this.nextFloatValue();
            }
            case 5: {
                return this.nextDoubleValue();
            }
        }
        throw new IllegalArgumentException("Unknown value type " + type);
    }

    public TextValue nextDigitString() {
        return this.nextDigitString(this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public TextValue nextDigitString(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)this.intBetween(48, 57);
        }
        return Values.utf8Value((byte[])bytes);
    }

    public TextValue nextAlphaTextValue() {
        return this.nextAlphaTextValue(this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public TextValue nextAlphaTextValue(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.generator.nextBoolean() ? (byte)this.intBetween(65, 90) : (byte)this.intBetween(97, 122);
        }
        return Values.utf8Value((byte[])bytes);
    }

    public TextValue nextAlphaNumericTextValue() {
        return this.nextAlphaNumericTextValue(this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public TextValue nextAlphaNumericTextValue(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        byte[] bytes = new byte[length];
        block5: for (int i = 0; i < length; ++i) {
            int nextInt = this.generator.nextInt(4);
            switch (nextInt) {
                case 0: {
                    bytes[i] = (byte)this.intBetween(65, 90);
                    continue block5;
                }
                case 1: {
                    bytes[i] = (byte)this.intBetween(97, 122);
                    continue block5;
                }
                case 2: 
                case 3: {
                    bytes[i] = (byte)this.intBetween(48, 57);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(nextInt + " is not an expected value");
                }
            }
        }
        return Values.utf8Value((byte[])bytes);
    }

    public TextValue nextAsciiTextValue() {
        return this.nextAsciiTextValue(this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public TextValue nextAsciiTextValue(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)this.intBetween(0, 127);
        }
        return Values.utf8Value((byte[])bytes);
    }

    public TextValue nextPrintableAsciiTextValue() {
        return this.nextPrintableAsciiTextValue(this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public TextValue nextPrintableAsciiTextValue(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)this.intBetween(32, 126);
        }
        return Values.utf8Value((byte[])bytes);
    }

    public TextValue nextBasicMultilingualPlaneTextValue() {
        return this.nextBasicMultilingualPlaneTextValue(this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public TextValue nextBasicMultilingualPlaneTextValue(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder(RandomValues.nextPowerOf2(length));
        for (int i = 0; i < length; ++i) {
            builder.addCodePoint(this.nextValidCodePoint(65535));
        }
        return builder.build();
    }

    public TextValue nextTextValue() {
        return this.nextTextValue(this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public TextValue nextTextValue(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder(RandomValues.nextPowerOf2(length));
        for (int i = 0; i < length; ++i) {
            builder.addCodePoint(this.nextValidCodePoint());
        }
        return builder.build();
    }

    private int nextValidCodePoint() {
        return this.nextValidCodePoint(this.configuration.maxCodePoint());
    }

    private int nextValidCodePoint(int maxCodePoint) {
        int codePoint;
        int type;
        while ((type = Character.getType(codePoint = this.intBetween(0, maxCodePoint))) == 0 || type == 18 || type == 19) {
        }
        return codePoint;
    }

    public Value nextValue() {
        return this.nextValue(this.nextType());
    }

    public Value nextValue(Types type) {
        switch (type) {
            case BOOLEAN: {
                return this.nextBooleanValue();
            }
            case BYTE: {
                return this.nextByteValue();
            }
            case SHORT: {
                return this.nextShortValue();
            }
            case STRING: {
                return this.nextTextValue();
            }
            case INT: {
                return this.nextIntValue();
            }
            case LONG: {
                return this.nextLongValue();
            }
            case FLOAT: {
                return this.nextFloatValue();
            }
            case DOUBLE: {
                return this.nextDoubleValue();
            }
            case LOCAL_DATE_TIME: {
                return this.nextLocalDateTimeValue();
            }
            case DATE: {
                return this.nextDateValue();
            }
            case LOCAL_TIME: {
                return this.nextLocalTimeValue();
            }
            case PERIOD: {
                return this.nextPeriod();
            }
            case DURATION: {
                return this.nextDuration();
            }
            case TIME: {
                return this.nextTimeValue();
            }
            case DATE_TIME: {
                return this.nextDateTimeValue();
            }
            case CARTESIAN_POINT: {
                return this.nextCartesianPoint();
            }
            case CARTESIAN_POINT_3D: {
                return this.nextCartesian3DPoint();
            }
            case GEOGRAPHIC_POINT: {
                return this.nextGeographicPoint();
            }
            case GEOGRAPHIC_POINT_3D: {
                return this.nextGeographic3DPoint();
            }
            case ARRAY: {
                return this.nextArray();
            }
        }
        throw new IllegalArgumentException("Unknown value type: " + (Object)((Object)type));
    }

    public ArrayValue nextArray() {
        return this.nextArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextArray(int minLength, int maxLength) {
        Types type;
        block22: while (true) {
            type = this.nextType();
            switch (type) {
                case BOOLEAN: {
                    return this.nextBooleanArray(minLength, maxLength);
                }
                case BYTE: {
                    return this.nextByteArray(minLength, maxLength);
                }
                case SHORT: {
                    return this.nextShortArray(minLength, maxLength);
                }
                case STRING: {
                    return this.nextStringArray(minLength, maxLength);
                }
                case INT: {
                    return this.nextIntArray(minLength, maxLength);
                }
                case LONG: {
                    return this.nextLongArray(minLength, maxLength);
                }
                case FLOAT: {
                    return this.nextFloatArray(minLength, maxLength);
                }
                case DOUBLE: {
                    return this.nextDoubleArray(minLength, maxLength);
                }
                case LOCAL_DATE_TIME: {
                    return this.nextLocalDateTimeArray(minLength, maxLength);
                }
                case DATE: {
                    return this.nextDateArray(minLength, maxLength);
                }
                case LOCAL_TIME: {
                    return this.nextLocalTimeArray(minLength, maxLength);
                }
                case PERIOD: {
                    return this.nextPeriodArray(minLength, maxLength);
                }
                case DURATION: {
                    return this.nextDurationArray(minLength, maxLength);
                }
                case TIME: {
                    return this.nextTimeArray(minLength, maxLength);
                }
                case DATE_TIME: {
                    return this.nextDateTimeArray(minLength, maxLength);
                }
                case CARTESIAN_POINT: {
                    return this.nextCartesianPointArray(minLength, maxLength);
                }
                case CARTESIAN_POINT_3D: {
                    return this.nextCartesian3DPointArray(minLength, maxLength);
                }
                case GEOGRAPHIC_POINT: {
                    return this.nextGeographicPointArray(minLength, maxLength);
                }
                case GEOGRAPHIC_POINT_3D: {
                    return this.nextGeographic3DPointArray(minLength, maxLength);
                }
                case ARRAY: {
                    continue block22;
                }
            }
            break;
        }
        throw new IllegalArgumentException("Unknown value type: " + (Object)((Object)type));
    }

    public PointArray nextCartesianPointArray() {
        return this.nextCartesianPointArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public PointArray nextCartesianPointArray(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        PointValue[] array = new PointValue[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.nextCartesianPoint();
        }
        return Values.pointArray((PointValue[])array);
    }

    public PointArray nextCartesian3DPointArray() {
        return this.nextCartesian3DPointArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public PointArray nextCartesian3DPointArray(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        PointValue[] array = new PointValue[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.nextCartesian3DPoint();
        }
        return Values.pointArray((PointValue[])array);
    }

    public PointArray nextGeographicPointArray() {
        return this.nextGeographicPointArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public PointArray nextGeographicPointArray(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        PointValue[] array = new PointValue[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.nextGeographicPoint();
        }
        return Values.pointArray((PointValue[])array);
    }

    public PointArray nextGeographic3DPointArray() {
        return this.nextGeographic3DPointArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public PointArray nextGeographic3DPointArray(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        PointValue[] array = new PointValue[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.nextGeographic3DPoint();
        }
        return Values.pointArray((PointValue[])array);
    }

    public ArrayValue nextLocalTimeArray() {
        return this.nextLocalTimeArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextLocalTimeArray(int minLength, int maxLength) {
        LocalTime[] array = this.nextLocalTimeArrayRaw(minLength, maxLength);
        return Values.localTimeArray((LocalTime[])array);
    }

    public LocalTime[] nextLocalTimeArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        LocalTime[] array = new LocalTime[length];
        for (int i = 0; i < length; ++i) {
            array[i] = LocalTime.ofNanoOfDay(this.nextLong(LocalTime.MIN.toNanoOfDay(), LocalTime.MAX.toNanoOfDay()));
        }
        return array;
    }

    public ArrayValue nextTimeArray() {
        return this.nextTimeArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextTimeArray(int minLength, int maxLength) {
        OffsetTime[] array = this.nextTimeArrayRaw(minLength, maxLength);
        return Values.timeArray((OffsetTime[])array);
    }

    public OffsetTime[] nextTimeArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        OffsetTime[] array = new OffsetTime[length];
        for (int i = 0; i < length; ++i) {
            array[i] = OffsetTime.ofInstant(this.randomInstant(), ZoneOffset.UTC);
        }
        return array;
    }

    public ArrayValue nextDateTimeArray() {
        return this.nextDateTimeArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextDateTimeArray(int minLength, int maxLength) {
        ZonedDateTime[] array = this.nextDateTimeArrayRaw(minLength, maxLength);
        return Values.dateTimeArray((ZonedDateTime[])array);
    }

    public ZonedDateTime[] nextDateTimeArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        ZonedDateTime[] array = new ZonedDateTime[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ZonedDateTime.ofInstant(this.randomInstant(), ZoneOffset.UTC);
        }
        return array;
    }

    public ArrayValue nextLocalDateTimeArray() {
        return this.nextLocalDateTimeArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextLocalDateTimeArray(int minLength, int maxLength) {
        LocalDateTime[] array = this.nextLocalDateTimeArrayRaw(minLength, maxLength);
        return Values.localDateTimeArray((LocalDateTime[])array);
    }

    public LocalDateTime[] nextLocalDateTimeArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        LocalDateTime[] array = new LocalDateTime[length];
        for (int i = 0; i < length; ++i) {
            array[i] = LocalDateTime.ofInstant(this.randomInstant(), ZoneOffset.UTC);
        }
        return array;
    }

    public ArrayValue nextDateArray() {
        return this.nextDateArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextDateArray(int minLength, int maxLength) {
        LocalDate[] array = this.nextDateArrayRaw(minLength, maxLength);
        return Values.dateArray((LocalDate[])array);
    }

    public LocalDate[] nextDateArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        LocalDate[] array = new LocalDate[length];
        for (int i = 0; i < length; ++i) {
            array[i] = LocalDate.ofEpochDay(this.nextLong(LocalDate.MIN.toEpochDay(), LocalDate.MAX.toEpochDay()));
        }
        return array;
    }

    public ArrayValue nextPeriodArray() {
        return this.nextPeriodArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextPeriodArray(int minLength, int maxLength) {
        TemporalAmount[] array = this.nextPeriodArrayRaw(minLength, maxLength);
        return Values.durationArray((TemporalAmount[])array);
    }

    public Period[] nextPeriodArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        Period[] array = new Period[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Period.of(this.generator.nextInt(), this.generator.nextInt(12), this.generator.nextInt(28));
        }
        return array;
    }

    public ArrayValue nextDurationArray() {
        return this.nextDurationArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ArrayValue nextDurationArray(int minLength, int maxLength) {
        TemporalAmount[] array = this.nextDurationArrayRaw(minLength, maxLength);
        return Values.durationArray((TemporalAmount[])array);
    }

    public Duration[] nextDurationArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        Duration[] array = new Duration[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Duration.of(this.nextLong(ChronoUnit.DAYS.getDuration().getSeconds()), ChronoUnit.SECONDS);
        }
        return array;
    }

    public DoubleArray nextDoubleArray() {
        return this.nextDoubleArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public DoubleArray nextDoubleArray(int minLength, int maxLength) {
        double[] array = this.nextDoubleArrayRaw(minLength, maxLength);
        return Values.doubleArray((double[])array);
    }

    public double[] nextDoubleArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this.generator.nextDouble();
        }
        return doubles;
    }

    public FloatArray nextFloatArray() {
        return this.nextFloatArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public FloatArray nextFloatArray(int minLength, int maxLength) {
        float[] array = this.nextFloatArrayRaw(minLength, maxLength);
        return Values.floatArray((float[])array);
    }

    public float[] nextFloatArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this.generator.nextFloat();
        }
        return floats;
    }

    public LongArray nextLongArray() {
        return this.nextLongArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public LongArray nextLongArray(int minLength, int maxLength) {
        long[] array = this.nextLongArrayRaw(minLength, maxLength);
        return Values.longArray((long[])array);
    }

    public long[] nextLongArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.generator.nextLong();
        }
        return longs;
    }

    public IntArray nextIntArray() {
        return this.nextIntArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public IntArray nextIntArray(int minLength, int maxLength) {
        int[] array = this.nextIntArrayRaw(minLength, maxLength);
        return Values.intArray((int[])array);
    }

    public int[] nextIntArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.generator.nextInt();
        }
        return ints;
    }

    public BooleanArray nextBooleanArray() {
        return this.nextBooleanArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public BooleanArray nextBooleanArray(int minLength, int maxLength) {
        boolean[] array = this.nextBooleanArrayRaw(minLength, maxLength);
        return Values.booleanArray((boolean[])array);
    }

    public boolean[] nextBooleanArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        boolean[] booleans = new boolean[length];
        for (int i = 0; i < length; ++i) {
            booleans[i] = this.generator.nextBoolean();
        }
        return booleans;
    }

    public ByteArray nextByteArray() {
        return this.nextByteArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ByteArray nextByteArray(int minLength, int maxLength) {
        byte[] array = this.nextByteArrayRaw(minLength, maxLength);
        return Values.byteArray((byte[])array);
    }

    public byte[] nextByteArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        byte[] bytes = new byte[length];
        int index = 0;
        while (index < length) {
            int rand = this.nextInt();
            int numBytesToShift = Math.min(length - index, 4);
            while (numBytesToShift > 0) {
                bytes[index++] = (byte)rand;
                --numBytesToShift;
                rand >>= 8;
            }
        }
        return bytes;
    }

    public ShortArray nextShortArray() {
        return this.nextShortArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public ShortArray nextShortArray(int minLength, int maxLength) {
        short[] array = this.nextShortArrayRaw(minLength, maxLength);
        return Values.shortArray((short[])array);
    }

    public short[] nextShortArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = (short)this.generator.nextInt();
        }
        return shorts;
    }

    public TextArray nextBasicMultilingualPlaneStringArray() {
        return Values.stringArray((String[])this.nextBasicMultilingualPlaneStringArrayRaw());
    }

    public String[] nextBasicMultilingualPlaneStringArrayRaw() {
        return this.nextBasicMultilingualPlaneStringArrayRaw(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength(), this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public String[] nextBasicMultilingualPlaneStringArrayRaw(int minLength, int maxLength, int minStringLength, int maxStringLength) {
        return this.nextStringArrayRaw(minLength, maxLength, () -> this.nextBasicMultilingualPlaneTextValue(minStringLength, maxStringLength).stringValue());
    }

    public TextArray nextAlphaNumericStringArray() {
        return this.nextAlphaNumericStringArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    public TextArray nextAlphaNumericStringArray(int minLength, int maxLength) {
        return Values.stringArray((String[])this.nextAlphaNumericStringArrayRaw(minLength, maxLength));
    }

    public String[] nextAlphaNumericStringArrayRaw(int minLength, int maxLength) {
        return this.nextAlphaNumericStringArrayRaw(minLength, maxLength, this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public String[] nextAlphaNumericStringArrayRaw(int minLength, int maxLength, int minStringLength, int maxStringLength) {
        return this.nextStringArrayRaw(minLength, maxLength, () -> this.nextAlphaNumericTextValue(minStringLength, maxStringLength).stringValue());
    }

    public TextArray nextStringArray() {
        return this.nextStringArray(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
    }

    private TextArray nextStringArray(int minLength, int maxLength) {
        return Values.stringArray((String[])this.nextStringArrayRaw(minLength, maxLength));
    }

    public String[] nextStringArrayRaw(int minLength, int maxLength) {
        return this.nextStringArrayRaw(minLength, maxLength, this.configuration.stringMinLength(), this.configuration.stringMaxLength());
    }

    public String[] nextStringArrayRaw(int minLength, int maxLength, int minStringLength, int maxStringLength) {
        return this.nextStringArrayRaw(minLength, maxLength, () -> this.nextTextValue(minStringLength, maxStringLength).stringValue());
    }

    private String[] nextStringArrayRaw(int minLength, int maxLength, StringCreator stringCreator) {
        int length = this.intBetween(minLength, maxLength);
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = stringCreator.create();
        }
        return strings;
    }

    public TimeValue nextTimeValue() {
        return TimeValue.time((OffsetTime)OffsetTime.ofInstant(this.randomInstant(), ZoneOffset.UTC));
    }

    public LocalDateTimeValue nextLocalDateTimeValue() {
        return LocalDateTimeValue.localDateTime((LocalDateTime)LocalDateTime.ofInstant(this.randomInstant(), ZoneOffset.UTC));
    }

    public DateValue nextDateValue() {
        return DateValue.date((LocalDate)LocalDate.ofEpochDay(this.nextLong(LocalDate.MIN.toEpochDay(), LocalDate.MAX.toEpochDay())));
    }

    public LocalTimeValue nextLocalTimeValue() {
        return LocalTimeValue.localTime((LocalTime)LocalTime.ofNanoOfDay(this.nextLong(LocalTime.MIN.toNanoOfDay(), LocalTime.MAX.toNanoOfDay())));
    }

    public DateTimeValue nextDateTimeValue() {
        return this.nextDateTimeValue(ZoneOffset.UTC);
    }

    public DateTimeValue nextDateTimeValue(ZoneId zoneId) {
        return DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.ofInstant(this.randomInstant(), zoneId));
    }

    public DurationValue nextPeriod() {
        return DurationValue.duration((Period)Period.of(this.generator.nextInt(), this.generator.nextInt(12), this.generator.nextInt(28)));
    }

    public DurationValue nextDuration() {
        return DurationValue.duration((Duration)Duration.of(this.nextLong(ChronoUnit.DAYS.getDuration().getSeconds()), ChronoUnit.SECONDS));
    }

    public Value nextTemporalValue() {
        int nextInt = this.generator.nextInt(6);
        switch (nextInt) {
            case 0: {
                return this.nextDateValue();
            }
            case 1: {
                return this.nextLocalDateTimeValue();
            }
            case 2: {
                return this.nextDateTimeValue();
            }
            case 3: {
                return this.nextLocalTimeValue();
            }
            case 4: {
                return this.nextTimeValue();
            }
            case 5: {
                return this.nextDuration();
            }
        }
        throw new IllegalArgumentException(nextInt + " not a valid temporal type");
    }

    public PointValue nextCartesianPoint() {
        double x = this.randomCartesianCoordinate();
        double y = this.randomCartesianCoordinate();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{x, y});
    }

    public PointValue nextCartesian3DPoint() {
        double x = this.randomCartesianCoordinate();
        double y = this.randomCartesianCoordinate();
        double z = this.randomCartesianCoordinate();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{x, y, z});
    }

    public PointValue nextGeographicPoint() {
        double longitude = this.randomLongitude();
        double latitude = this.randomLatitude();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{longitude, latitude});
    }

    public PointValue nextGeographic3DPoint() {
        double longitude = this.randomLongitude();
        double latitude = this.randomLatitude();
        double z = this.randomCartesianCoordinate();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{longitude, latitude, z});
    }

    private double randomLatitude() {
        double spatialDefaultMinLatitude = -90.0;
        double spatialDefaultMaxLatitude = 90.0;
        return this.doubleBetween(spatialDefaultMinLatitude, spatialDefaultMaxLatitude);
    }

    private double randomLongitude() {
        double spatialDefaultMinLongitude = -180.0;
        double spatialDefaultMaxLongitude = 180.0;
        return this.doubleBetween(spatialDefaultMinLongitude, spatialDefaultMaxLongitude);
    }

    private double randomCartesianCoordinate() {
        double spatialDefaultMinExtent = -1000000.0;
        double spatialDefaultMaxExtent = 1000000.0;
        return this.doubleBetween(spatialDefaultMinExtent, spatialDefaultMaxExtent);
    }

    private double doubleBetween(double min, double max) {
        return this.generator.nextDouble() * (max - min) + min;
    }

    public PointValue nextPointValue() {
        int nextInt = this.generator.nextInt(4);
        switch (nextInt) {
            case 0: {
                return this.nextCartesianPoint();
            }
            case 1: {
                return this.nextCartesian3DPoint();
            }
            case 2: {
                return this.nextGeographicPoint();
            }
            case 3: {
                return this.nextGeographic3DPoint();
            }
        }
        throw new IllegalStateException(nextInt + " not a valid point type");
    }

    public <T> T among(T[] among) {
        return among[this.generator.nextInt(among.length)];
    }

    public <T> T among(List<T> among) {
        return among.get(this.generator.nextInt(among.size()));
    }

    public <T> void among(List<T> among, Consumer<T> action) {
        if (!among.isEmpty()) {
            T item = this.among(among);
            action.accept(item);
        }
    }

    public int intBetween(int min, int max) {
        return min + this.generator.nextInt(max - min + 1);
    }

    public long nextLong(long bound) {
        return Math.abs(this.generator.nextLong()) % bound;
    }

    public long nextLong() {
        return this.generator.nextLong();
    }

    public <T> T[] selection(T[] among, int min, int max, boolean allowDuplicates) {
        assert (min <= max);
        int diff = min == max ? 0 : this.generator.nextInt(max - min);
        int length = min + diff;
        Object[] result = (Object[])Array.newInstance(among.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            T candidate;
            do {
                candidate = this.among(among);
            } while (!allowDuplicates && RandomValues.contains(result, candidate));
            result[i] = candidate;
        }
        return result;
    }

    private static <T> boolean contains(T[] array, T contains) {
        for (T item : array) {
            if (!Objects.equals(item, contains)) continue;
            return true;
        }
        return false;
    }

    private Instant randomInstant() {
        return Instant.ofEpochSecond(this.nextLong(LocalDateTime.MIN.toEpochSecond(ZoneOffset.UTC), LocalDateTime.MAX.toEpochSecond(ZoneOffset.UTC)), this.nextLong(1000000000L));
    }

    private long nextLong(long origin, long bound) {
        return this.nextLong(bound - origin + 1L) + origin;
    }

    private Types nextType() {
        return TYPES[this.generator.nextInt(TYPES.length)];
    }

    private static int nextPowerOf2(int i) {
        return 1 << 32 - Integer.numberOfLeadingZeros(i);
    }

    @FunctionalInterface
    private static interface StringCreator {
        public String create();
    }

    public static class Default
    implements Configuration {
        @Override
        public int stringMinLength() {
            return 5;
        }

        @Override
        public int stringMaxLength() {
            return 20;
        }

        @Override
        public int arrayMinLength() {
            return 1;
        }

        @Override
        public int arrayMaxLength() {
            return 10;
        }

        @Override
        public int maxCodePoint() {
            return 0x10FFFF;
        }
    }

    public static interface Configuration {
        public int stringMinLength();

        public int stringMaxLength();

        public int arrayMinLength();

        public int arrayMaxLength();

        public int maxCodePoint();
    }

    public static enum Types {
        BOOLEAN,
        BYTE,
        SHORT,
        STRING,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        LOCAL_DATE_TIME,
        DATE,
        LOCAL_TIME,
        PERIOD,
        DURATION,
        TIME,
        DATE_TIME,
        CARTESIAN_POINT,
        CARTESIAN_POINT_3D,
        GEOGRAPHIC_POINT,
        GEOGRAPHIC_POINT_3D,
        ARRAY;

    }
}

