/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.helpers.Exceptions;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.rule.RandomRule;

public class RandomExtension
extends StatefullFieldExtension<RandomRule>
implements AfterEachCallback {
    private static final String RANDOM = "random";
    private static final ExtensionContext.Namespace RANDOM_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"random"});

    protected String getFieldKey() {
        return RANDOM;
    }

    protected Class<RandomRule> getFieldType() {
        return RandomRule.class;
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return RANDOM_NAMESPACE;
    }

    protected RandomRule createField(ExtensionContext extensionContext) {
        RandomRule randomRule = new RandomRule();
        randomRule.setSeed(System.currentTimeMillis());
        randomRule.reset();
        return randomRule;
    }

    public void afterEach(ExtensionContext context) {
        long seed = ((RandomRule)this.getStoredValue(context)).seed();
        context.getExecutionException().ifPresent(t -> Exceptions.withMessage((Throwable)t, (String)(t.getMessage() + ": random seed used:" + seed + "L")));
        this.removeStoredValue(context);
    }
}

