/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction.database;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.exceptions.KernelException;
import org.neo4j.fabric.bookmark.LocalBookmark;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.TaggingPlanDescriptionWrapper;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.notifications.NotificationImplementation;
import org.neo4j.notifications.NotificationWrapping;
import org.neo4j.router.impl.subscriber.DelegatingQueryExecution;
import org.neo4j.router.impl.subscriber.StatementLifecycleQuerySubscriber;
import org.neo4j.router.query.Query;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.TransactionInfo;
import scala.Option;

public class LocalDatabaseTransaction
implements DatabaseTransaction {
    private final Location.Local location;
    private final TransactionInfo transactionInfo;
    private final InternalTransaction internalTransaction;
    private final TransactionalContextFactory transactionalContextFactory;
    private final QueryExecutionEngine queryExecutionEngine;
    private final TransactionBookmarkManager bookmarkManager;
    private final LocalGraphTransactionIdTracker transactionIdTracker;
    private ConstituentTransactionFactory constituentTransactionFactory;
    private final Set<TransactionalContext> openExecutionContexts = new HashSet<TransactionalContext>();

    public LocalDatabaseTransaction(Location.Local location, TransactionInfo transactionInfo, InternalTransaction internalTransaction, TransactionalContextFactory transactionalContextFactory, QueryExecutionEngine queryExecutionEngine, TransactionBookmarkManager bookmarkManager, LocalGraphTransactionIdTracker transactionIdTracker, ConstituentTransactionFactory constituentTransactionFactory) {
        this.location = location;
        this.transactionInfo = transactionInfo;
        this.internalTransaction = internalTransaction;
        this.transactionalContextFactory = transactionalContextFactory;
        this.queryExecutionEngine = queryExecutionEngine;
        this.bookmarkManager = bookmarkManager;
        this.transactionIdTracker = transactionIdTracker;
        this.constituentTransactionFactory = constituentTransactionFactory;
    }

    public void setConstituentTransactionFactory(ConstituentTransactionFactory constituentTransactionFactory) {
        this.constituentTransactionFactory = constituentTransactionFactory;
    }

    public Location location() {
        return this.location;
    }

    @Override
    public void commit() {
        this.closeContexts();
        if (this.internalTransaction.isOpen()) {
            this.translateLocalError((ThrowingAction<KernelException>)((ThrowingAction)() -> this.internalTransaction.commit()));
        }
        long transactionId = this.transactionIdTracker.getTransactionId(this.location);
        this.bookmarkManager.localTransactionCommitted(this.location, new LocalBookmark(transactionId));
    }

    @Override
    public void rollback() {
        this.closeContexts();
        if (this.internalTransaction.isOpen()) {
            this.translateLocalError((ThrowingAction<KernelException>)((ThrowingAction)() -> ((InternalTransaction)this.internalTransaction).rollback()));
        }
    }

    @Override
    public void close() {
        this.closeContexts();
        if (this.internalTransaction.isOpen()) {
            this.translateLocalError((ThrowingAction<KernelException>)((ThrowingAction)() -> ((InternalTransaction)this.internalTransaction).close()));
        }
    }

    @Override
    public void terminate(Status reason) {
        this.terminateIfPossible(reason);
    }

    public void terminateIfPossible(Status reason) {
        if (this.internalTransaction.isOpen() && this.internalTransaction.terminationReason().isEmpty()) {
            this.internalTransaction.terminate(reason);
        }
    }

    @Override
    public QueryExecution executeQuery(Query query, QuerySubscriber querySubscriber, QueryStatementLifecycles.StatementLifecycle statementLifecycle, Set<InternalNotification> routerNotifications) {
        return (QueryExecution)this.translateLocalError(() -> {
            TransactionalContext transactionalContext = this.transactionalContextFactory.newContextForQuery(this.internalTransaction, statementLifecycle.getMonitoredQuery(), this.transactionInfo.queryExecutionConfiguration(), this.constituentTransactionFactory);
            statementLifecycle.startExecution(true);
            this.openExecutionContexts.add(transactionalContext);
            QueryExecution execution = this.queryExecutionEngine.executeQuery(query.text(), query.parameters(), transactionalContext, true, (QuerySubscriber)new QuerySubscriberImpl(transactionalContext, querySubscriber, statementLifecycle), QueryExecutionMonitor.NO_OP);
            return new TransactionalContextQueryExecution(execution, transactionalContext, routerNotifications);
        });
    }

    private void translateLocalError(ThrowingAction<KernelException> throwingAction) {
        try {
            throwingAction.apply();
        }
        catch (KernelException kernelException) {
            throw FabricException.translateLocalError((Exception)((Object)kernelException));
        }
    }

    private <T> T translateLocalError(ThrowingSupplier<T, KernelException> throwingSupplier) {
        try {
            return (T)throwingSupplier.get();
        }
        catch (KernelException kernelException) {
            throw FabricException.translateLocalError((Exception)((Object)kernelException));
        }
    }

    private void closeContexts() {
        this.openExecutionContexts.forEach(TransactionalContext::close);
    }

    public InternalTransaction internalTransaction() {
        return this.internalTransaction;
    }

    @Override
    public boolean isOpen() {
        return this.internalTransaction.isOpen();
    }

    private class QuerySubscriberImpl
    extends StatementLifecycleQuerySubscriber {
        private final TransactionalContext transactionalContext;

        public QuerySubscriberImpl(TransactionalContext transactionalContext, QuerySubscriber querySubscriber, QueryStatementLifecycles.StatementLifecycle statementLifecycle) {
            super(querySubscriber, statementLifecycle);
            this.transactionalContext = transactionalContext;
        }

        @Override
        public void onResultCompleted(QueryStatistics statistics) {
            super.onResultCompleted(statistics);
            LocalDatabaseTransaction.this.openExecutionContexts.remove(this.transactionalContext);
            this.transactionalContext.close();
        }

        @Override
        public void onError(Throwable throwable) throws Exception {
            super.onError(throwable);
            LocalDatabaseTransaction.this.openExecutionContexts.remove(this.transactionalContext);
            this.transactionalContext.close();
        }
    }

    private class TransactionalContextQueryExecution
    extends DelegatingQueryExecution {
        private final TransactionalContext transactionalContext;
        private final Set<InternalNotification> notifications;

        TransactionalContextQueryExecution(QueryExecution queryExecution, TransactionalContext transactionalContext, Set<InternalNotification> notifications) {
            super(queryExecution);
            this.transactionalContext = transactionalContext;
            this.notifications = notifications;
        }

        @Override
        public void cancel() {
            super.cancel();
            LocalDatabaseTransaction.this.openExecutionContexts.remove(this.transactionalContext);
            this.transactionalContext.close();
        }

        @Override
        public ExecutionPlanDescription executionPlanDescription() {
            return new TaggingPlanDescriptionWrapper(super.executionPlanDescription(), LocalDatabaseTransaction.this.location.getDatabaseName());
        }

        @Override
        public Iterable<Notification> getNotifications() {
            List<NotificationImplementation> additionalNotifications = this.notifications.stream().map(n -> NotificationWrapping.asKernelNotificationJava((Option)Option.empty(), (InternalNotification)n)).toList();
            return Iterables.concat((Iterable[])new Iterable[]{super.getNotifications(), additionalNotifications});
        }

        @Override
        public Iterable<GqlStatusObject> getGqlStatusObjects() {
            List<NotificationImplementation> additionalNotifications = this.notifications.stream().map(n -> NotificationWrapping.asKernelNotificationJava((Option)Option.empty(), (InternalNotification)n)).toList();
            return Iterables.concat((Iterable[])new Iterable[]{super.getGqlStatusObjects(), additionalNotifications});
        }
    }
}

