/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.router.impl.transaction.QueryRouterTransactionMonitor;
import org.neo4j.router.impl.transaction.RouterTransactionImpl;
import org.neo4j.router.transaction.RouterTransaction;
import org.neo4j.util.VisibleForTesting;

public class RouterTransactionManager {
    private final Set<RouterTransactionImpl> transactions = ConcurrentHashMap.newKeySet();
    private final QueryRouterTransactionMonitor transactionMonitor;

    public RouterTransactionManager(QueryRouterTransactionMonitor transactionMonitor) {
        this.transactionMonitor = transactionMonitor;
    }

    public void registerTransaction(RouterTransactionImpl transaction) {
        this.transactions.add(transaction);
        this.transactionMonitor.startMonitoringTransaction(transaction);
    }

    public void unregisterTransaction(RouterTransactionImpl transaction) {
        this.transactions.remove(transaction);
        this.transactionMonitor.stopMonitoringTransaction(transaction);
    }

    public Optional<RouterTransaction> findTransactionContaining(InternalTransaction transaction) {
        return this.transactions.stream().filter(routerTransaction -> routerTransaction.getInternalTransactions().stream().anyMatch(itx -> itx.kernelTransaction() == transaction.kernelTransaction())).map(RouterTransaction.class::cast).findAny();
    }

    @VisibleForTesting
    public Set<RouterTransaction> registeredTransactions() {
        return new HashSet<RouterTransaction>(this.transactions);
    }
}

