/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.router.query.DatabaseReferenceResolver;

public class DefaultDatabaseReferenceResolver
implements DatabaseReferenceResolver {
    private final DatabaseReferenceRepository repository;

    public DefaultDatabaseReferenceResolver(DatabaseReferenceRepository repository) {
        this.repository = repository;
    }

    @Override
    public DatabaseReference resolve(String name) {
        return this.resolve(new NormalizedDatabaseName(name));
    }

    @Override
    public DatabaseReference resolve(NormalizedDatabaseName name) {
        return (DatabaseReference)this.repository.getByAlias(name).or(() -> this.getCompositeConstituentAlias(name)).orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(name));
    }

    @Override
    public boolean isPropertyShardDatabase(NormalizedDatabaseName name) {
        Optional maybeSpd = this.repository.getSpdDatabaseReference();
        return maybeSpd.map(spd -> spd.entityDetailStores().values().stream().anyMatch(shardReference -> shardReference.fullName().equals((Object)name))).orElse(false);
    }

    private Optional<DatabaseReference> getCompositeConstituentAlias(NormalizedDatabaseName name) {
        return this.repository.getCompositeDatabaseReferences().stream().flatMap(comp -> comp.constituents().stream()).filter(constituent -> constituent.fullName().equals((Object)name)).findFirst();
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(NormalizedDatabaseName databaseNameRaw) {
        return () -> new DatabaseNotFoundException("Graph not found: " + databaseNameRaw.name());
    }
}

